<?tei:SOF abbr.tag ?>
<!-- $Id: abbr.tag,v 1.4 94/03/28 19:59:41 msmcq Exp $ -->
<!-- $Log:	abbr.tag,v $
# Revision 1.4  94/03/28  19:59:41  msmcq
# punctuations, tyops (i don't know)
# 
# Revision 1.3  1994/01/04  13:13:16  lou
# not #inherited but %inherited dumpkopf
#
# Revision 1.2  1993/11/30  14:27:34  lou
# fixed typo in example
#
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 93-06-05 : MSM : clean up bad comment                    -->
<!-- 93-05-24 : PR : changes to conform to TC matter          -->
<!-- 92-12-09 : MSM : suppress membership in edit class       -->
<!-- 92-11-09 : MSM : supply missing endtag for gi            -->
<!-- 92-11-05 : MSM : correct spqr, cosmetic chgs to attdefs  -->
<!-- ******************************************************** abbr -->
<tagDoc id=ABBR usage=opt>
<gi>abbr</gi>
<name>abbreviation
<desc>contains an abbreviation of any sort.
<attList>
<!-- .................................................... expan -->
<attDef usage=opt>
<attName>expan
<name>expansion
<desc>gives an expansion of the abbreviation.
<datatype>CDATA
<valDesc>any string of characters
<default>#IMPLIED
<eg><![ CDATA [
 The address is Southmoor <abbr expan='road'>Rd</>.
]]>
</eg>
<remarks><p>Only one expansion may be given for an abbreviation; if
different expansions are to be proposed, the tags for critical
apparatus
should be used.
</attDef>
<!-- ................................................... resp -->
<attDef usage=opt>
<attName>resp
<name>responsibility
<desc>signifies the editor or transcriber responsible for supplying
the expansion of the abbreviation held as the value of the
<att>expan</att> attribute.
<datatype>IDREF
<valDesc>must be one of the identifiers declared in the document
header, associated with a person asserted as responsible for some
aspect of the text's creation, transcription, editing or encoding
(see chapter <xref target=CE>).
<default>%INHERITED
<eg><![ CDATA [
 The address is Southmoor <abbr expan='Road' resp=LB>Rd</>.
]]>
</eg>
<remarks><p>If no expansion is given, the <att>resp</att> attribute
has no meaning.
</attDef>
<!-- ................................................... cert -->
<attDef usage=opt>
<attName>cert
<name>certainty
<desc>signifies the degree of certainty ascribed to the expansion of
the abbreviation.
<datatype>CDATA
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... type -->
<attDef usage=opt>
<attName>type
<desc>allows the encoder to classify the abbreviation according to
some
convenient typology.
<datatype>CDATA
<valList type=open>
<val>suspension     <desc>the abbreviation provides the first
       letter(s) of the word or phrase, omitting the remainder.
<val>contraction    <desc>the abbreviation omits some letter(s) in the middle.
<val>brevigraph     <desc>the abbreviation comprises a special symbol or mark.
<val>superscription <desc>the abbreviation includes writing above
the line.
<val>acronym        <desc>the abbreviation comprises the initial
letters of the words of a phrase.
<val>title          <desc>the abbreviation is for a title of
address (Dr, Ms, Mr, ...)
<val>organization   <desc>the abbreviation is for the name of an
organization.
<val>geographic     <desc>the abbreviation is for a geographic  name.
</valList>
<default>#IMPLIED
<eg><![ CDATA [
  <abbr type=acronym>RSVP</abbr>
  <abbr type=organization>SPQR</abbr>
  <abbr type=brevigraph>&per;</abbr>
  <abbr type=contraction>yr hbl servt</abbr>
]]>
</eg>
<!-- This example removed because I never heard of it         -->
<!-- ! there are more things in this world, dear Horatio ...  -->
<!--  < abbr expan='Si vales bene est et valeo'             -->
<!-- type='acronym' > SVBEEV < / >                            -->
 
<remarks><p>The <att>type</att> attribute is provided for the sake of
those who wish to classify abbreviations at their point of  occurrence;
this may be useful in some circumstances, though usually the same
abbreviation will have the same type in all occurrences.  As the
sample values make clear, abbreviations may be classified by the method
used  to construct them, the method of writing them, or the referent of
the  term abbreviated; the typology used is up to the encoder and
should be carefully planned to meet the needs of the expected use.
</attDef>
</attList>
<!-- < exemplum>< eg>< ![ CDATA [                             -->
<!--   < abbr type=organization                             -->
<!--     expan='societas populique romanorum'                 -->
<!--     resp=author>SPQR< /abbr>                           -->
<!-- ]]>                                                      -->
<!-- Don't you mean:                                          -->
<exemplum><eg><![ CDATA [
  <abbr type=organization
    expan='senatus populusque romanorum'
    resp=author>SPQR</abbr>
]]>
</eg></exemplum>
 
<remarks><p>This tag is the mirror image of the <gi>expan</gi> tag;
both allow the encoder to transcribe both an abbreviation and its
expansion. In <gi>abbr</gi>, however, the original is transcribed as
the content  of the element and the expansion as an attribute value;
<gi>expan</gi> reverses this.  The choice between the two is up to the
user.
<p>The <gi>abbr</gi> tag is not required; if appropriate, the encoder
may transcribe abbreviations in the source text silently, without
tagging them.  If abbreviations are not transcribed directly but
<emph>expanded</emph> silently, then the TEI header should so
indicate.
<p>For a typology of ME abbreviations, see <citation>A. G. Petty,
<title>English literary hands from Chaucer to
Dryden</title> (London:  Edward Arnold, 1977), pp. 22-25.</citation>
<part type=top name=core>
<classes names="DATA">
<dataDesc>May contain character data and phrase-level elements.
<elemDecl>- -  (%phrase.seq;)
</elemDecl>
<xref type=div2 target=CONAAB>
</tagDoc>
 
 
<?tei:EOF abbr.tag ?>
