<?tei:SOF addspan.tag ?>
<!-- $Id: addspan.tag,v 1.6 98/01/28 13:43:23 tei Exp $ -->
<!--*
    * $Log:	addspan.tag,v $
# Revision 1.6  98/01/28  13:43:23  tei
# cosmetic change to log
# 
    * Revision 1.5  1998/01/28 13:41:23  tei
    * LB changes Jan 98, changed class membership to editincl
    *
    * Revision 1.4  1994/08/29  15:18:45  msmcq
    * fixes for unreachability
    *
    * Revision 1.3  1994/03/25  17:21:51  msmcq
    * cleanup of miscellaneous tagdocs:  some typos,
    * some INHERITED errors, supplied explicit end-tags for many attdef parts
    * to shield a weakness of oddref1 (now fixed)
    *
    * Revision 1.2  1994/03/08  03:20:58  msmcq
    * revision for P3
    *
    * Revision 1.1  1993/08/03  02:27:04  msmcq
    * tagdoc files:  resynching uicvm and onions
    *-->
<!-- Revisions:                                               -->
<!-- 4 Jan 98: LB : changed class membership from edit to editincl -->
<!-- 94-08-04 : MSM : fix REACH:  make member of EDIT         -->
<!-- 94-03-21 : MSM : correct 'inherited' error               -->
<!-- 94-03-03 : MSM : add TYPE att for // to delSpan          -->
<!-- 94-03-03 : MSM : change example from add.span            -->
<!-- *********************************************** addSpan -->
<tagDoc id=ADDSPAN usage=opt>
<gi>addSpan</gi>
<name>added span of text
<desc>marks the beginning of a longer sequence of text added by an
author, scribe, annotator or corrector (see also
<gi>add</gi>).
<attList>
<!-- ................................................... type -->
<attDef usage=opt>
<attName>type
<desc>classifies the addition, using any convenient typology.
<datatype>CDATA
<valDesc>Any string of characters.
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- .................................................. place -->
<attDef usage=rec>
<attName>place
<desc>indicates where the addition is made.
<datatype>CDATA
<valList type=semi>
<val>inline <desc>addition is made in a space left in the witness by
an
earlier scribe.
<val>supralinear <desc>addition is made above the line.
<val>infralinear <desc>addition is made below the line.
<val>marginleft <desc>addition is made in left margin.
<val>marginright <desc>addition is made in right margin.
<val>margintop <desc>addition is made in top margin.
<val>marginbot <desc>addition is made in bottom margin.
<val>overleaf <desc>addition is made on the other side of the leaf.
</valList>
<default>#IMPLIED
<eg><![ CDATA [
Then they went back home.
<addSpan place='supralinear marginright overleaf' to=p23>
When they got there, ...
]]>
</eg>
<remarks><p>Long additions may frequently spill from one location to
another; in this case, more than one value may be given, as shown in
the example above.
</attDef>
<!-- ................................................... resp -->
<attDef usage=opt>
<attName>resp
<name>responsible
<desc>signifies the editor or transcriber responsible for identifying
the hand of the addition.
<datatype>IDREF
<valDesc>must be one of the identifiers declared in the document
header, associated with a person asserted as responsible for some
aspect of the text's creation, transcription, editing or encoding
(see chapter <xref target=CE>).
<default>%INHERITED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... cert -->
<attDef usage=opt>
<attName>cert
<name>certainty
<desc>signifies the degree of certainty ascribed to the
identification of the hand of the addition.
<datatype>CDATA
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... hand -->
<attDef usage=opt>
<attName>hand
<desc>signifies the hand of the agent which made the addition.
<datatype>IDREF
<valDesc>must be one of the hand identifiers declared in the document
header (see section <xref target="PHDH">).
<default>%INHERITED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ..................................................... to -->
<attDef usage=req>
<attName>to
<desc>identifies the endpoint of the added passage, by giving the ID
of an <gi>anchor</gi> or other empty element placed there.
<datatype>IDREF
<valDesc>any valid SGML identifier, used on a later element.
<default>#REQUIRED
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>Both the beginning and the end of the added material must
be marked; the beginning by the <gi>addSpan</gi> element itself, the
end by the <att>to</att> attribute.
</attDef>
</attList>
<exemplum><eg><![ CDATA [
 
]]>
</eg></exemplum>
<remarks><p> (optional)
<part type=top name=tc>
<classes names="EDITINCL">
<dataDesc>Empty.
<elemDecl>- O  EMPTY
</elemDecl>
<xref target=PHAD>
</tagDoc>




<?tei:EOF addspan.tag ?>
