<?tei:SOF admin.tag ?>
<!-- $Id: admin.tag,v 1.4 94/03/21 14:33:05 lou Exp $ -->
<!-- $Log:	admin.tag,v $
# Revision 1.4  94/03/21  14:33:05  lou
# second major typo purge
# 
# Revision 1.3  1994/01/04  12:13:27  lou
# fix xrefs
#
# Revision 1.2  1993/09/15  23:08:09  msmcq
# Change class membership
#
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 93-09-15 : MSM : include in class termmisc               -->
<!-- 92-12-23 : MSM : expand TC37dd entity                    -->
<!-- 92-12-18 : MSM : add /p to exemplum                      -->
<!-- 92-12-18 : MSM : remove FLATTERM class                   -->
<!-- 92-12-18 : SEW, MSM : incorporate SEW's changes          -->
<!-- 92-12-15 : MSM : add date, resp attributes               -->
<!-- 92-12-15 : MSM : change suggested values for type        -->
<!-- 92-11-23 : MSM : define default                          -->
<!-- 92-11-23 : MSM : added end-tag for gi                    -->
<!-- ************************************************** admin -->
<tagDoc id=ADMIN usage=rec>
<gi>admin</gi>
<name>administrative information
<desc>within a <gi>termEntry</gi> element, contains administrative
information pertaining to data management and documentation of the
entry.
<attList>
<!-- ................................................... type -->
<attDef usage=opt>
<attName>type
<desc>identifies the administrative event or information using some
typology, preferably the dictionary of data element types specified in
ISO WD 12 620.
<datatype>CDATA
<valList type=semi>
<val>responsibility<desc>The <gi>admin</gi> element identifies the agency
                   or individual responsible for the data element or
                   entry.
<val>created <desc>The <gi>admin</gi> element describes the creation of
                   the data element or entry.
<val>updated <desc>The <gi>admin</gi> element describes the update or
                   modification of the data element or entry.
<val>approved <desc>The <gi>admin</gi> element describes the final
                   approval of the data element or entry.
<val>domain <desc>The element indicates the subject area to which a
                  concept pertains.
<val>subdomain <desc>The element indicates the subdomain of the subject
                  area to which the concept pertains.
</valList>
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>A much fuller list of values for the <att>type</att>
attribute may be generated from the dictionary of data element types
under preparation as ISO TC 37/SC 3/WD 12 620, Computational Aids in
Terminology.  See ISO 12 620 for fuller details.</remarks>
</attDef>
<!-- ................................................... date -->
<attDef usage=rwa>
<attName>date
<desc>indicates the date of the administrative event or information
marked by the element.
<datatype>CDATA
<valDesc>a date in ISO standard form (yyyy-mm-dd).
<default>%ISO-date
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>The <att>date</att> attribute should be used on the
<gi>admin</gi> element to indicate the date of the administrative
process (creation, update, approval, etc.) being recorded, rather than a
separate <gi>date</gi> element linked to the <gi>admin</gi> element by a
<att>depend</att> attribute.
</attDef>
<!-- ................................................... resp -->
<attDef usage=rwa>
<attName>resp
<name>responsibility
<desc>indicates the agency or individual responsible for the entry
or data element on which the <gi>admin</gi> element depends, or for
the administrative procedure recorded by the <gi>admin</gi> element.
<datatype>CDATA
<valDesc>any string of characters (usually the acronym of the agency or
the initials of an individual).
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>Some terminological database systems treat responsibility
as a cross reference to a personnel entry.
</attDef>
</attList>
<exemplum><p>For domain or other similar information, the <gi>admin</gi>
element should be used to provide the domain information as the content
of the element:</p>
<eg><![ CDATA [
<admin depend=te84.11
       type='domain'
       resp='ISO/TC 61, Plastics'>plastics</admin>
]]>
</eg>
</exemplum>
<exemplum><p>In the case of responsibility information or information
about maintenance of the entry, the <gi>admin</gi> element may have no
content at all, its information all having been conveyed by the
attributes <att>type</att>, <att>date</att>, and <att>resp</att>:</p>
<eg><![ CDATA [
<admin depend=te84.11
       type='responsibility'
       resp='ISO/TC 61, Plastics'></admin>
]]>
</eg></exemplum>
<exemplum>
<eg><![ CDATA [
<admin depend=te84.11
       type='created'
       date='1991-10-23'
       resp='SEW'></admin>
<admin depend=te84.11
       type='updated'
       date='1992-12-15'
       resp='MSM'></admin>
]]>
</eg></exemplum>
<remarks><p>Administrative data take widely varying forms in different
terminological databases; the <att>type</att> attribute should be used
to indicate the particular class of administrative information involved.
The <gi>admin</gi> element should also be used to record dates of
major changes to the term entry, if these are to be recorded.
<part type=base name=term>
<classes names="TERMMISC">
<dataDesc>May contain character data and phrase-level elements.
<elemDecl>- O  (%paraContent;)
</elemDecl>
<xref target=TEDTF>
<xref target=TEDTN>
<xref type=div1 target=TETA>
</tagDoc>
<?tei:EOF admin.tag ?>
