<?tei:SOF align.tag ?>
<!-- $Id: align.tag,v 1.1 93/06/23 11:28:40 lou Exp $ -->
<!-- $Log:	align.tag,v $
# Revision 1.1  93/06/23  11:28:40  lou
# Initial checkin
#  -->
<!-- Revisions:                                               -->
<!-- 93-06-04 : MSM : fix empty valdesc                       -->
<!-- 93-02-10 : MSM : change target of xref                   -->
<tagDoc id="ALIGN" usage=rec><gi>align</gi>
<desc>defines an alignment map used to synchronize locations in time or
space within a text.</desc>
<attList>
<attDef><attName>type
   <desc>specifies whether the items pointed to from the locations
    contained in this alignment are to be aligned in time or space.
   <datatype>(time | space)
   <valList>
   <val>time  <desc>the alignment refers to time, i.e. targets are
         synchronous and locations follow each other.
   <val>space <desc>the alignment refers to space.
    </valList>
   <default>#REQUIRED
<attDef><attName>origin
   <desc>specifies the starting point in time or space for this
   alignment.
   <datatype>IDREF
   <valDesc>must point to another ALIGN element logically preceding this
   one.
   </valDesc>
   <default>#IMPLIED
</attDef>
<attDef><attName>units
<!-- was 'measurement' -->
   <desc>specifies the default units in which relative distances between
    locations are to be measured.
   <datatype>NMTOKEN
   <valDesc>a semi-closed list of recognized abbreviations such as sec,
    min, cm, in
   </valDesc>
   <default>#IMPLIED
</attDef>
<attDef><attName>interval
<!-- was fixed.dist -->
   <desc>a non-zero value indicates that all locations contained by the
    alignment are to be regarded as following at regular intervals
    of the length specified; a zero value indicates that locations
    are consecutive.
   <datatype>NUTOKEN
   <valDesc>zero or a positive number</valDesc>
   <default>0
   <remarks><p>If relative timings are supplied on a loc which is on a
    alignment that has a nonzero interval, which should be believed?
    or is it an error?
</attDef>
<!-- the following attribute is in AIling1.5, but I haven't included it
    because I don't understand what it's for (LB)
<attDef><attName>loc.ref
   <desc>
   <datatype>(origin | previous | floating)
   <valDesc>One of the defined keywords.
   </valDesc>
   <default>previous
</attDef>
-->
</attList>
<exemplum><eg>
<![ CDATA[
<align type=time interval=10 units=min>
  <loc id=P1>
  <loc id=P2>
  <loc id=P3>
</align>
]]>
</eg>
<p>This example defines three points in time,
named P1, P2 and P3, which are ten minutes apart.</exemplum>
<remarks>
<part type=base name=ana><classes>
<dataDesc>Contains a series of <gi>loc</gi> elements only</dataDesc>
<elemDecl>- - (loc+)</elemDecl>
<xref target=TSSAPA></tagDoc>
<?tei:EOF align.tag ?>
