<?tei:SOF arc.tag ?>
<!-- ********** ARC                                           -->
<!-- $Id: arc.tag,v 1.4 94/01/04 12:13:29 lou Exp $ -->
<!-- $Log:	arc.tag,v $
# Revision 1.4  94/01/04  12:13:29  lou
# fix xrefs
# 
# Revision 1.3  1993/09/15  22:56:03  msmcq
# Changes as of mid-September
# -->
<!-- ********** ARC                                           -->
<!-- Revisions:                                               -->
<!-- 28 dec 93 : LB : fix cross reference -->
<!-- 93-09-15 : MSM : cleanup                                 -->
<!-- 93-09-10 : MSM : Normalize GI case                       -->
<!-- 93-07-23 : DTL : modify P2 version                       -->
<!--                  merge ARC and EDGE tags                 -->
<!--                  eliminate LABEL content (retain label=) -->
<!--                  add label2= (for encoding transducers)  -->
<!--                  eliminate special drawing attributes    -->
<!--                      (use rend=)                         -->
<!-- ********** ARC                                           -->
<tagDoc id=ARC usage=opt>
<gi>arc</gi>
<desc>encodes an arc, the connection from one node to another in a graph.
<attList>
<attDef id=ARLAB usage=opt>
<attName>label
<desc>gives a label for an arc.
<datatype>CDATA
<valDesc>A character string.
<default>#IMPLIED
</attDef>
<attDef id=ARLAB2 usage=opt>
<attName>label2
<desc>gives a second label for an arc.
<datatype>CDATA
<valDesc>A character string.
<default>#IMPLIED
<remarks><p>Use this attribute together with the <att>label</att>
attribute if a transducer is being encoded.
</attDef>
<attDef id=ARFROM usage=req>
<attName>from
<desc>gives the ID of the node which is adjacent from this arc.
<datatype>IDREF
<valDesc>The ID of a node.
<default>#REQUIRED
</attDef>
<attDef id=ARTO usage=req>
<attName>to
<desc>gives the ID of the node which is adjacent to this arc.
<datatype>IDREF
<valDesc>The ID of a node.
<default>#REQUIRED
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
<arc from=t3 to=t3 label='OLD' label2='VIEUX'>
]]>
</eg>
</exemplum>
<remarks><p>The <gi>arc</gi> element must be used if the arcs are
labeled.  Otherwise, arcs can be encoded using the <att>adj</att>,
<att>adjTo</att> and <att>adjFrom</att> attributes on the <gi>node</gi>
tags in the graph.  Both <gi>arc</gi> tags and adjacency attributes can
be used, but the resulting encoding would be highly redundant.
<part type=top name=graphs><classes>
<dataDesc>empty
<elemDecl>- O EMPTY</elemDecl>
<xref target=GDGR>
</tagDoc>
<?tei:EOF arc.tag ?>
