<?tei:SOF cell.tag ?>
<!-- Revisions:                                               -->
<!-- 94-02-28 : MSM : allow end-tag omission                  -->
<!-- 94-02-28 : MSM : define as paraContent, not phrase.seq   -->
<!-- 94-02-24 : MSM : full stop after desc                    -->
<!-- $Id: -->
<!-- $Log: -->
<!-- ************************************************** cell -->
<tagDoc id=CELL usage=rwa>
<gi>cell</gi>
<desc>contains one cell of a table. </desc>
<attList>
<attDef><attName>role
<desc>indicates the kind of information held in the cell.
<datatype>CDATA
<valList type=semi>
<val>label<desc>labelling or descriptive information only.
<val>data<desc>data values.
</valList>
<default>data
<remarks><p>The value specified overrides any default specified by the
<att>role</att> attribute of the parent <gi>row</gi> element,
for this cell only.
</remarks>
</attDef>
<attDef><attName>rows
<desc>indicates the number of rows occupied by this cell.
<datatype>NUMBER
<valDesc>A number; a value greater than one indicates that this cell
spans several rows.
<default>1
<remarks><p>Where several cells span several rows, it may be more convenient
to use nested tables.
</remarks>
</attDef>
<attDef><attName>cols
<desc>indicates the number of columns occupied by this cell.
<datatype>NUMBER
<valDesc>A number; a value greater than one indicates that this cell
spans several columns.
<default>1
<remarks><p>Where an initial cell spans an entire row, it should be treated as
a heading.
</remarks>
</attDef>
</attList>
<exemplum><eg><![ CDATA [
<row>
  <cell role=label>General conduct</cell>
  <cell role=data>Not satisfactory, on account of his great
       unpunctuality and inattention to duties</cell>
</row>
]]>
</eg>
</exemplum>
<remarks><p>
<part type=top name=ft>
<classes>
<dataDesc>
<elemDecl>- O (%paraContent)
</elemDecl>
<xref type=div1 target=FTTAB1>
</tagDoc>
<?tei:EOF cell.tag ?>
