<?tei:SOF certain.tag ?>
<!-- $Id: certain.tag,v 1.5 94/04/07 02:53:52 msmcq Exp $ -->
<!-- $Log:	certain.tag,v $
# Revision 1.5  94/04/07  02:53:52  msmcq
# cosmetic changes only
# 
# Revision 1.4  1994/03/15  11:10:22  lou
# minor typos etc
#
# Revision 1.3  1994/01/04  12:13:40  lou
# fix xrefs
#
# Revision 1.2  1993/09/22  19:03:38  msmcq
# as of publication of CE
#
# Revision 1.1  1993/08/03  02:27:04  msmcq
# tagdoc files:  resynching uicvm and onions
# -->
<!-- Revisions:                                               -->
<!-- 94-04-06 : MSM : cosmetics                               -->
<!-- 12 mar: add to globincl class -->
<!-- 93-09-17 : MSM : correct examples                        -->
<!-- 93-06-02 : MSM : revise desc of assertedVal, degree      -->
<!-- 93-05-27 : MSM : revise for dtd conformance              -->
<!-- 93-05-27 : MSM : revision received from Allen Renear     -->
<!-- TEICE2 ********************************** certainty -->
 
<tagDoc id=CERTAIN usage=opt>
<gi>certainty</gi>
 
<desc>indicates the degree of certainty or uncertainty associated with
some aspect of the text markup.
 
<attList>
<!-- ................................ target -->
<attDef usage=req>
<attName>target
<desc>points at the elements whose markup is uncertain.
<datatype>IDREFS
<valDesc>one or more SGML ID values.
<default>#REQUIRED
<eg><![ CDATA [
Elizabeth went to <persName id=P1>Essex</persName>
<certainty target=P1 locus=gi degree='0.6'>
]]>
</eg>
<remarks><p>If more than one IDREF is given, the
<gi>certainty</gi> element is interpreted as applying to all.
If no ID is present on the element being annotated, the
attribute should give the ID of a <gi>ptr</gi> element which
points at the element being annotated; for further discussion
of this indirect pointing mechanism, see chapter <xref
target=SA>.
</attDef>
<!-- ................................. locus -->
<attDef usage=req>
<attName>locus
<desc>indicates the precise location of the uncertainty in the
markup: applicability of the element, precise position of the
start- or end-tag, value of a specific attribute, etc.
<datatype>CDATA
<valList type=semi>
<val>#gi <desc>uncertain whether the element used actually applies
to the passage.
<val>#startloc <desc>start-tag may not be correctly located.
<val>#endloc <desc>end-tag may not be correctly located.
<val>#location <desc>both the start-tag and the end-tag may not
be correctly located.
<val>name<desc>the value given for the attribute
<att>name</att> is uncertain.
<val>#transcribedContent <desc>the content of the element may
not be a correct transcription of the source text.
<val>#suppliedContent <desc>the content of the element may not
have been correctly supplied by the reader, e.g. as in the
cases of <gi>corr</gi> and <gi>abbrev</gi> elements.
</valList>
<default>#REQUIRED
<remarks><p>The <q>#</q> distinguishes the terms of the
controlled vocabulary from possible collisions with attribute
names.  Extensions to this vocabulary should also use this
prefix.
<!-- This is precisely backwards from our conventions elsewhere -->
<!-- would be better to drop all sharp signs and say *name  (LB) -->
</attDef>
<!-- ............................. assertedValue-->
<attDef usage=rec>
<attName>assertedValue
<desc>provides an alternative value for the aspect of the markup in
question---an alternative generic identifier, transcription,
or attribute value, or the ID of an <gi>anchor</gi> element (to
indicate an alternative starting or ending location).  If an
<att>assertedValue</att> is given, the confidence level specified by
<att>degree</att> applies to the alternative markup specified by
<att>assertedValue</att>; if none is given, it applies to the markup
in the text.
<datatype>CDATA
<valDesc>generic identifier, attribute value, location (e.g.
indicated by an IDREF to an <gi>anchor</gi> element or to an
<gi>xptr</gi> element), or other appropriate alternative
value.
<default>#IMPLIED
<eg><![ CDATA [
Elizabeth went to <persName id=P1>Essex</persName>
<certainty target=P1 locus='#gi'
           assertedValue='place' degree='0.2'>
]]>
</eg>
<remarks><p>This attribute makes it possible to indicate the
degree of confidence in a specific alternative to some aspect
of the markup. In the example above the encoder is expressing
the likelihood (.2) that the generic identifier should be
<gi>place</gi> rather than <gi>persName</gi>, which is the coded
element.
</attDef>
 
<!-- .................................. desc -->
<attDef usage=rec>
<attName>desc
<desc>further describes the uncertainty in prose, perhaps
indicating its nature, cause, or the justification for the
degree of confidence asserted.
<datatype>CDATA
<valDesc>a prose description of how and why the markup is
uncertain.
<default>#IMPLIED
<eg><![ CDATA [
Elizabeth went to <persName id=P1>Essex</persName>
<certainty target=P1 locus='#gi'  degree='0.2'
desc='As this was written in the Spring
it is probably the Earl, not the town'>
]]>
</eg>
<remarks><p>In a given project, it may be possible to enumerate
a finite list of recognized types and causes of uncertainty; in
such cases, it will be useful to control the vocabulary used in
this attribute, to aid later mechanical manipulation.  It is
not possible to suggest such a controlled vocabulary for
general use.
</attDef>
<!-- .................................. given -->
<attDef usage=rec>
<attName>given
<desc>indicates conditions assumed in the assignment of a
degree of confidence.
<datatype>CDATA
<valDesc>a characterization of the conditions which are assumed
in the assignment of a degree of confidence.  This may be in
prose.
<default>#IMPLIED
<eg><![ CDATA [
<!-- in the header, hand 'h1' is
    identified as that of 'msm' ... -->
<hand id=H1 scribe=msm>
 
 <!-- in the text, the scribe has corrected 'Wessex'
     into 'Essex' ... -->
Elizabeth went to <corr id=C1 sic='Wessex' resp=msm>Essex</corr>.
 
<!-- we are 60% certain that hand h1 is 'msm',
     and 90% certain that if h1 is 'msm', then
     it is 'msm' who corrected 'Wessex'
     into 'Essex'.  -->
<certainty id=H1 target=H1 locus=scribe degree='0.6'>
<certainty target=P1 locus=resp given=h1 degree='0.9'>
]]>
</eg>
<remarks><p>A project may wish to control the vocabulary used
in this attribute.
<p>The envisioned typical value of this attribute would be the
identifier of another <gi>certainty</gi> element or a list of
such identifiers.
<!-- this conditional discussion belongs in the chapter, or nowhere -->
It may thus be possible to
construct probability networks by chaining <gi>certainty</gi>
elements together.  Such networks would ultimately be grounded
in unconditional <gi>certainty</gi> elements (with no value for
<att>given</att>).  The semantics of this chaining would be
understood in this way: if a <gi>certainty</gi> element is
specified, via an IDREF, as the assumption, then it is not the
attribution of uncertainty that is the assumption, but rather
the assertion itself.  For instance, in the example above,
the first <gi>certainty</gi> element indicates that the
confidence in the identification of the new scribe as
<q>msm</q>.  The second indicates the degree of confidence that
<q>Essex</q> is a personal name, given that the new scribe is
<q>msm</q>.  Note that the given in the second <gi>certainty</gi>
element is not the assertion that the likelihood that msm is
the new scribe is 0.6, but simply the assertion that msm is the
new scribe; this is a recommended convention to facilitate
building networks.
<p>The ambitious encoder may wish to attempt complex networks
or probability assertions, experimenting with references to
other elements or prose assertions, and deploying feature
structure connectives such as <gi>alt</gi>, <gi>join</gi>, and
<gi>not</gi>.  However, we do not believe that the
<gi>certainty</gi> element gives, at this time, a comprehensive
ambiguity-free system for indicating certainty.
<!-- then why are we droning on about it at such length?  (LB)-->
</attDef>
<!-- .................................. degree -->
<attDef usage=opt>
<attName>degree
<desc>indicates the degree of confidence assigned to the aspect
of the markup named by the <att>locus</att> attribute.
<datatype>CDATA
<valDesc>Values of <att>degree</att> might be yes or no, the
reals between 0 and 1, or traditional characterizations such as
<q>doubtful</q>, <q>circa</q>, etc.  Generally we recommend
decimal numbers between 0 and 1, where  larger  numbers denote
a greater degree of confidence in the assertions; 0
representing <q>certainly false</q> and 1 representing <q>certainly
true</q>.
<default>#IMPLIED
</attDef>
</attList>
<exemplum>
<p>For discussion of this example, see section <xref target=CECECE>.</p>
<eg><![ CDATA [
Earnest went to <anchor id=A1> old
<persName id=P1>Saybrook</persName>.
 
<certainty id=C1 target=P1 locus='#gi' degree='0.6'>
<certainty given=c1 target=P1 locus=startloc degree='0.9'>
 
<certainty id=C2 target=P1 locus='#gi'
           assertedValue='persName' degree='0.4'>
<certainty given=c2 target=P1 locus=startloc degree='0.5'>
<certainty id=C3
           given=c1 target=P1 locus=startloc
           assertedValue='a1' degree='0.5' >
]]>
</eg></exemplum>
 
<part type=top name=ce>
<classes names=METADATA>
<dataDesc>Empty.
<elemDecl>- O  EMPTY
</elemDecl>
<xref target=CECECE>
</tagDoc>
<?tei:EOF certain.tag ?>
