<?tei:SOF damage.tag ?>
<!-- $Id: damage.tag,v 1.6 1998/02/05 17:15:38 tei Exp $ -->
<!--*
    * $Log: damage.tag,v $
    * Revision 1.6  1998/02/05 17:15:38  tei
    * fix log message; make examples parse
    *
    * Revision 1.5  94/08/29  15:20:05  msmcq
    * fixes for unreachability
    * (divGen et al.)
    * 
    * Revision 1.4  1994/04/08  01:52:06  msmcq
    * Last fixes for FD in P3, etc.
    * 
    * Revision 1.3  1994/03/25  17:21:51  msmcq
    * cleanup of miscellaneous tagdocs:  some typos,
    * some INHERITED errors, supplied explicit end-tags for many attdef parts
    * to shield a weakness of oddref1 (now fixed)
    * 
    * Revision 1.2  1994/02/07  20:56:16  msmcq
    * revisions for P3
    * 
    * Revision 1.1  1993/08/03  02:27:04  msmcq
    * tagdoc files:  resynching uicvm and onions
    * -->
<!-- Revisions:                                               -->
<!-- 94-08-04 : MSM : fix REACH:  make member of EDIT         -->
<!-- 94-04-07 : MSM : full stop after etc                     -->
<!-- 94-03-21 : MSM : correct 'inherited' error               -->
<!-- 94-02-04 : MSM : correct desc on degree att              -->
<!-- ENTITY damage   system 'damage.tag' -->      <!-- damage tag -->
<!-- ************************************************* damage -->
<tagDoc id=DAMAGE usage=opt>
<gi>damage</gi>
<desc>contains an area of damage to the text witness.
<attList>
<!-- ................................................... type -->
<attDef usage=opt>
<attName>type
<desc>classifies the damage according to any convenient typology.
<datatype>CDATA
<valDesc>any phrase describing the damage, e.g. <q>faded</q>,
<q>overbound</q>, <q>water</q>, <q>charred with loss of paper</q>.
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................. extent -->
<!-- was: length.  Necessary where damage tag has no content  -->
<attDef usage=opt>
<attName>extent
<desc>indicates approximately how much text is in the damaged area,
in letters, minims, inches, or any appropriate unit, where this
cannot be deduced from the contents of the tag.  For example, the
damage may span structural divisions in the text so that the tag must
then be empty of content.
<datatype>CDATA
<valDesc>any measurement phrase, e.g. <q>25 letters</q>, <q>2 x 3
inches</q>.
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... resp -->
<attDef usage=opt>
<attName>resp
<desc>indicates the individual responsible for identifying the area
of damage.
<datatype>IDREF
<valDesc>must be one of the identifiers declared in the document
header, associated with a person asserted as responsible for some
aspect of the text's creation, transcription, editing or encoding
(see chapter <xref target=CE>).
<default>%INHERITED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... hand -->
<attDef usage=opt>
<attName>hand
<desc>In the case of damage (deliberate defacement, etc.) assignable
to an identifiable hand, signifies the hand responsible for the
damage.
<datatype>IDREF
<valDesc>must be one of the hand identifiers declared in the document
header (see section <xref target="PHDH">).
<default>%INHERITED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... agent -->
<attDef usage=opt>
<attName>agent
<desc>In the case of damage resulting from an identifiable cause,
signifies the causative agent.
<datatype>CDATA
<valDesc>any prose description of the agency of damage.
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... degree -->
<!-- The Robin Cover memorial attribute........................ -->
<attDef usage=opt>
<attName>degree
<desc>Signifies the degree of damage according to a convenient scale.
The <gi>damage</gi> tag with the <att>degree</att> attribute should
only be used where the text may be read with some confidence; text
supplied from other sources should be tagged as <gi>supplied</gi>.
<datatype>CDATA
<valDesc>an alphanumeric categorization of the degree of damage, as
<q>40%</q>.
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>The <gi>damage</gi> tag with the <att>degree</att>
attribute should only be used where the text may be read with
confidence despite the damage.  It is appropriate where it is desired
to record the fact of damage, though this has not affected the
readability of the text (as may be the case with weathered
inscriptional materials).  Where the damage has rendered the text
more or less illegible either the <gi>unclear</gi> tag (for partial
illegibility) or the <gi>omit</gi> tag (for complete illegibility,
with no text supplied) should be used, with the information
concerning the damage given in the attribute values of these tags.
See section <xref target=PHCOMB> for discussion of the use of these
tags in particular circumstances.
</attDef>
</attList>
<exemplum><eg><![ CDATA [
 
]]>
</eg></exemplum>
<remarks><p>Since damage to text witnesses frequently makes them
harder to read, the <gi>damage</gi> element will often contain an
<gi>unclear</gi> element.  If the damaged area is not continuous in
the text (e.g. a stain on one side of a page), the <gi>join</gi>
element may be used to indicate which <gi>damage</gi> and
<gi>unclear</gi> elements are part of the same physical phenomenon.
<p>The <gi>damage</gi>, <gi>omit</gi>, <gi>del</gi>, <gi>unclear</gi>
and <gi>supplied</gi> elements may be closely allied in use.  See
section <xref target=PHCOMB> for discussion of which element is
appropriate for which circumstance.
<part type=top name=tc>
<classes names="EDIT">
<dataDesc>May contain character data and phrase-level elements.
<elemDecl>- O  (%paraContent;)
</elemDecl>
<xref target=PHDA>
</tagDoc>
<?tei:EOF damage.tag ?>
