<?tei:SOF date.tag ?>
<!-- $Id: date.tag,v 1.6 94/04/08 01:52:06 msmcq Exp $ -->
<!-- $Log:	date.tag,v $
# Revision 1.6  94/04/08  01:52:06  msmcq
# Last fixes for FD in P3, etc.
# 
# Revision 1.5  1994/03/25  17:21:51  msmcq
# cleanup of miscellaneous tagdocs:  some typos,
# some INHERITED errors, supplied explicit end-tags for many attdef parts
# to shield a weakness of oddref1 (now fixed)
#
# Revision 1.4  1994/03/07  16:16:31  lou
# revised for initial check in of ND
#
# Revision 1.3  1994/01/15  21:06:26  msmcq
# revisions in connection with DI, for P3.
#
# Revision 1.2  1993/09/16  15:06:37  msmcq
# Add to terminologyInclusions class
#
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 94-04-07 : MSM : rebreak some lines (Script problem)     -->
<!-- 94-03-21 : MSM : correct ID of DATE class to cldate      -->
<!-- 6 mar: LB rename certainty attribute to avoid confusion -->
<!-- 94-01-15 : MSM : correct ref to stdVals                  -->
<!-- 93-09-15 : MSM : include in class termincl               -->
<!-- 92-12-22 : MSM : replace iso 2014 by 8601 as per G Budin, SEW -->
<!-- 92-12-07 : MSM : change TYPE att to CALENDAR             -->
<!-- 92-12-06 : MSM : add DATE class                          -->
<!-- ******************************************************** date -->
<tagDoc id=DATE usage=opt>
<gi>date</gi>
<desc>contains a date in any format.
<attList>
<attDef usage=opt>
<attName>calendar
<desc>indicates the system or calendar to which the date belongs.
<datatype>CDATA
<valDesc>Recommended values include:
<term>Gregorian</term>,
<term>Julian</term>,
<term>Roman</term>,
<term>Mosaic</term>,
<term>Revolutionary</term>,
<term>Islamic</term>.
</valDesc>
<default>#IMPLIED
<eg><![ CDATA [
He was born on <date calendar=Gregorian>Feb. 22,
1732</date> (<date calendar=Julian
value='1732-2-22'>Feb. 11, 1731/32, O.S.</date>).
]]>
<!-- Entry on George Washington, Columbia Encyclopedia, 2d ed. -->
<!-- ed. William Bridgwater and Elizabeth J. Sherwood         -->
<!-- (Morningside Heights:  Columbia UP, 1950), p. 2111       -->
</eg>
</attDef>
<attDef usage=opt>
<attName>value
<desc>gives the value of the date in some standard form, usually
yyyy-mm-dd.
<datatype>CDATA
<valDesc>Any string representing a date in standard format; recommended
form is <q>yyyy-mm-dd</q>, as defined by ISO 8601: 1988, <title>Data
elements and interchange formats --- Information interchange ---
Representation of dates and times.</title>
<default>#IMPLIED
<eg><![ CDATA [
This list begins in the year 1632, more precisely
on Trinity Sunday, i.e. the Sunday after Pentecost,
in that year the <date calendar=Julian value=1632-6-6>
27th of May (old style)</date>.
]]>
</eg>
<!-- need source for this example -->
<!-- Appears not to be Leipziger Matrikel                     -->
<!-- Maybe something in MHD?                                  -->
<remarks><p>For simple dates, the value should give the Gregorian date
in the form (yyyy-mm-dd) specified by ISO 8601.  More complicated dates
or special applications may require another calendar or another form;
these should be documented in the <gi>stdVals</gi> element in the TEI
Header.
</attDef>
<attDef usage=opt>
<attName>certainty
<desc>indicates the degree of precision to be attributed to the date.
<datatype>CDATA
<valDesc>Any appropriate value, e.g.
<term>ca.</term>,
<term>approx</term>,
<term>after</term>,
<term>before</term>.
</valDesc>
<default>#IMPLIED
</attDef>
</attList>
<exemplum><eg><![ CDATA [
<date value='1980-02' certainty=approx>early February 1980</date>
]]>
</eg></exemplum>
<exemplum><eg><![ CDATA [
Given on the <date value='1977-06-12'>Twelfth Day of June
in the Year of Our Lord One Thousand Nine Hundred and
Seventy-seven of the Republic the Two Hundredth and first
and of the University the Eighty-Sixth.</date>
]]>
</eg></exemplum>
<!-- diploma of A.B. awarded by Stanford University -->
<exemplum><eg><![ CDATA [
<date value='1990-09'>September 1990</date>
]]>
</eg></exemplum>
<remarks>
<part type=top name=core>
<classes names="DATA CLDATE TERMINCL">
<dataDesc>May contain character data and phrase-level elements.
<elemDecl>- -  (%phrase.seq;)
</elemDecl>
<xref type=div3 target=CONADA>
<xref type=div3 target=HD24>
<xref type=div3 target=HD6>
<xref type=div3 target=COBICOI>
<xref type=div3 target=TETA>
<xref type=div3 target=CCAHSE>
<xref target=NDDATE>
</tagDoc>
<?tei:EOF date.tag ?>
