<?tei:SOF daterang.tag ?>
<!-- $Id: daterang.tag,v 1.3 98/01/28 19:22:39 tei Exp $ -->
<!--*
    * $Log:	daterang.tag,v $
# Revision 1.3  98/01/28  19:22:39  tei
# LB changes of 1998-01
# 
    * Revision 1.2  1994/03/28  20:07:24  msmcq
    * correct ID of date class (cldate, not date)
    *
    * Revision 1.1  1993/06/23  11:28:40  lou
    * Initial checkin
    *-->
<!-- Revisions:                                               -->
<!-- 4 Jan 98 : LB : specify type=closed on vallist -->
<!-- 94-03-28 : MSM : correct class ref to cldate             -->
<!-- 92-12-07 : MSM : change TYPE att to CALENDAR             -->
<!-- 92-12-06 : MSM : add DATE class                          -->
<!-- **************************************************** daterang -->
<tagDoc id="DATERANG" usage="opt">
<gi>dateRange</gi>
<name>date range</name>
<desc>contains two dates or another phrase delimiting a time period.</desc>
<attList>
<attDef usage="opt">
<attName>calendar</attName>
<desc>indicates the system or calendar to which the date belongs.</desc>
<datatype>CDATA</datatype>
<valDesc>Recommended values include:
<term>Gregorian</term>,
<term>Julian</term>,
<term>Roman</term>,
<term>Mosaic</term>,
<term>Revolutionary</term>,
<term>Islamic</term>.
</valDesc>
<default>#IMPLIED</default>
</attDef>
<attDef usage="opt">
<attName>from</attName>
<desc>indicates the starting point of the period in standard form.</desc>
<datatype>CDATA</datatype>
<valDesc>any date in a standard form; recommended form is yyyy-mm-dd.</valDesc>
<default>#IMPLIED</default>
<remarks><p>The value should conform to the standard form declared in
the <gi>std.vals</gi> element in the TEI header.</p></remarks>
</attDef>
<attDef usage="opt">
<attName>to</attName>
<desc>indicates the ending point of the period in standard form.</desc>
<datatype>CDATA</datatype>
<valDesc>any date in a standard form; recommended form is yyyy-mm-dd.</valDesc>
<default>#IMPLIED</default>
<remarks><p>The value should conform to the standard form declared in
the <gi>stdVals</gi> element in the TEI header.</p></remarks>
</attDef>
<attDef usage="opt">
<attName>exact</attName>
<desc>indicates the precision to be attached to either or both dates
specified.</desc>
<datatype>(to|from|both|none)</datatype>
<valList type="closed">
<val>to</val><desc>the <att>to</att> date is exact</desc>
<val>from</val><desc>the <att>from</att> date is exact</desc>
<val>both</val><desc>both dates are exact</desc>
<val>none</val><desc>both dates are approximate or unspecified</desc>
</valList>
<default>#IMPLIED</default>
<eg>
<![ CDATA[
  <dateRange from=1100 to=1120 exact=from>
       Early 12th century</dateRange>
]]>
</eg>
<remarks><p>date values should conform to the standard form declared in
the <gi>stdVals</gi> element in the TEI header.</p></remarks>
</attDef>
</attList>
<exemplum><eg><![ CDATA [
He edited (<dateRange from=1846 to=1848>1846-48</dateRange>)
the first collection of Hungarian folk poetry.
]]>
</eg></exemplum>
<part type="top" name="core">
<classes names="DATA CLDATE">
<dataDesc>May contain character data and phrase-level elements.</dataDesc>
<elemDecl>- O  (%phrase.seq;)
</elemDecl>
<xref target="CONADA" type="div3">
</tagDoc>
<?tei:EOF daterang.tag ?>
