<?tei:SOF datestru.tag ?>
<!-- Revisions:                                               -->
<!-- 94-03-28 : MSM : correct class ref to cldate             -->
<!-- $Id: datestru.tag,v 1.4 1998/02/09 14:30:22 tei Exp $ -->
<!--*
    * $Log: datestru.tag,v $
    * Revision 1.4  1998/02/09 14:30:22  tei
    * fixing egs....
    *
    * Revision 1.3  94/03/28  20:07:24  msmcq
    * correct ID of date class (cldate, not date)
    * 
    * Revision 1.2  1994/03/15  11:10:24  lou
    * minor typos etc
    * 
    * Revision 1.1  1994/03/07  16:16:39  lou
    * Initial revision
    * -->
<!-- ******************************************************** dateStruct -->
<tagDoc id=DATESTRU usage=opt>
<gi>dateStruct</gi>
<desc>contains an internally structured representation of a date.
<attList>
<attDef usage=opt>
<attName>calendar
<desc>indicates the system or calendar to which the date belongs.
<datatype>CDATA
<valDesc>Recommended values include:
<term>Gregorian</term>,
<term>Julian</term>,
<term>Roman</term>,
<term>Mosaic</term>,
<term>Revolutionary</term>,
<term>Islamic</term>.
</valDesc>
<default>#IMPLIED
</attDef>
<attDef usage=opt>
<attName>exact
<desc>indicates the degree of precision to be attributed to the date.
<datatype>CDATA
<valDesc>Any appropriate value, e.g.
<term>ca.</term>,
<term>approx</term>,
<term>after</term>,
<term>before</term>.
</valDesc>
<default>#IMPLIED
</attDef>
</attList>
<exemplum><eg><![ CDATA [
<dateStruct value='1990-09'>
  <month>September</month>
  <year>1990</year>
</dateStruct>
]]>
</eg></exemplum>
<exemplum><eg><![ CDATA [
Given on the
<dateStruct value='1977-06-12'>
    <day reg=12>  Twelfth</day> Day of
    <month reg=06>June</month>
    <year reg=1977 type=nominal>in the Year of Our Lord
    One Thousand Nine Hundred and Seventy-seven</year>
    <dateStruct>
      <offSet>of</offSet><year reg=1776>the Republic</year>
      <distance>the Two Hundredth and first</distance>
    </dateStruct>and
    <dateStruct>
      <offSet>of</offSet><year reg=1891>the University</year>
      <distance>the Eighty-Sixth.</distance>
    </dateStruct>
</dateStruct>
]]>
</eg></exemplum>
<!-- diploma of A.B. awarded by Stanford University -->
<remarks>
<part type=top name=core>
<classes names="DATA CLDATE TERMINCL TEMPEXP">
<dataDesc>May contain character data and temporal expression elements.
<elemDecl>- -  ((%m.temporalExpr; | #pcdata)+)
</elemDecl><!-- this model precludes date as subcomponent -->
<xref target=NDDATE>
<xref type=div3 target=CONADA>
<xref type=div3 target=HD24>
<xref type=div3 target=HD6>
<xref type=div3 target=COBICOI>
<xref type=div3 target=TETA>
<xref type=div3 target=CCAHSE>
</tagDoc>
<?tei:EOF datestru.tag ?>
