<?tei:SOF del.tag ?>
<!-- $Id: del.tag,v 1.5 98/01/28 19:22:39 tei Exp $ -->
<!--*
    * $Log:	del.tag,v $
# Revision 1.5  98/01/28  19:22:39  tei
# LB changes of 1998-01
# 
    * Revision 1.4  1994/03/08  03:24:27  msmcq
    * revision for P3
    * 
    * Revision 1.3  1994/01/04  12:14:04  lou
    * fix xrefs
    * 
    * Revision 1.2  1993/08/03  01:59:34  msmcq
    * fix INHERITED keyword
    *-->
<!-- Revisions:                                               -->
<!-- 4 Jan 98 : LB : it's <gap>, not <omit> stupid!           -->
<!-- 94-03-07 : MSM : change DESC as per CH suggestion        -->
<!-- 93-08-02 : MSM : Added RCS id                            -->
<!-- 93-06-21 : MSM : correct INHERITED                       -->
<!-- 92-11-09 : MSM : supply missing end-tag for gi           -->
<!-- 92-11-09 : MSM : specify datatype on REND                -->
<!-- ********************************************************* del --
>
<tagDoc id="DEL" usage="opt">
<gi>del</gi>
<name>deletion</name>
<desc>contains a letter, word or passage deleted, marked as deleted,
or otherwise indicated as superfluous or spurious in the copy text by an
author, scribe, annotator or corrector.</desc>
<attList>
<attDef usage="opt">
<attName>rend</attName>
<name>rendition</name>
<desc>indicates how the deletion was indicated in the copy text.</desc>
<datatype>CDATA</datatype>
<valList type="open">
    <val>subpunction</val>  <desc>dots below the line indicate matter to be
                            deleted.</desc>
    <val>overstrike</val>   <desc>lines through the text indicated matter to be deleted.</desc>
    <val>erasure</val>      <desc>material to be deleted has been erased
(but
                            remains legible enough to transcribe).</desc>
    <val>bracketed</val>    <desc>brackets around the material indicate
that
                            it is spurious or superfluous.</desc>
</valList>
<default>#IMPLIED</default>
<eg><![ CDATA [
]]>
</eg>
</attDef>
<attDef usage="opt">
<attName>type</attName>
<desc>classifies the type of deletion using any convenient typology.</desc>
<datatype>CDATA</datatype>
<valDesc>any string identifying the class of deletion.</valDesc>
<default>#IMPLIED</default>
<eg><![ CDATA [
]]>
</eg>
<remarks><p>No recommendation of any particular typology is made
here;
to record the manner in which the deletion is signaled, use
<att>rend</att>, not <att>type</att>.</p></remarks>
</attDef>
<attDef usage="opt">
<attName>status</attName>
<desc>may be used to indicate faulty deletions, e.g.
strikeouts which include too much or too little text.</desc>
<datatype>CDATA</datatype>
<valDesc>any description of flaws in the marking of a deletion, e.g.
<q>excess left</q>, <q>excess right</q>, <q>short left</q>, <q>short
right</q>.</valDesc>
<default>'unremarkable'</default>
<eg><![ CDATA [
]]>
</eg>
<remarks><p>Status information on each deletion is needed rather
rarely
except in critical editions from authorial manuscripts.</p></remarks>
</attDef>
<!-- ................................................... resp -->
<attDef usage="opt">
<attName>resp</attName>
<name>responsible</name>
<desc>signifies the editor or transcriber responsible for identifying
the hand of the deletion.</desc>
<datatype>IDREF</datatype>
<valDesc>must be one of the identifiers declared in the document
header, associated with a person asserted as responsible for some
aspect of the text's creation, transcription, editing or encoding
(see chapter <xref target="CE">).</valDesc>
<default>%INHERITED</default>
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... cert -->
<attDef usage="opt">
<attName>cert</attName>
<name>certainty</name>
<desc>signifies the degree of certainty ascribed to the
identification of the hand of the deletion.</desc>
<datatype>CDATA</datatype>
<default>#IMPLIED</default>
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... hand -->
<attDef usage="opt">
<attName>hand</attName>
<desc>signifies the hand of the agent which made the deletion.</desc>
<datatype>IDREF</datatype>
<valDesc>must be one of the hand identifiers declared in the document
header (see section <xref target="PHDH">).</valDesc>
<default>%INHERITED</default>
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
</attList>
<exemplum><eg><![ CDATA [
<l><del type=overtyped>Mein</del> Frisch
   <del type=overstrike>schwebt</del> weht der Wind
]]>
</eg></exemplum>
<remarks><p>Cf. <gi>gap</gi>.</p>
<p>Degrees of uncertainty over what can
still be read may be indicated by use of the
<gi>certainty</gi> element (see <xref target="CE">).</p>
<p>This element  should be used for deletion of shorter
sequences of text, typically single words or phrases.
The <gi>delSpan</gi> element should be used for longer
sequences of text, for those containing structural
subdivisions, and for those containing overlapping
additions and deletions.</p>
<p>The text deleted must be at least partially legible, in order for
the encoder to be able to transcribe it.  If it is not legible at
all, the <gi>del</gi> tag should not be used.  Rather, the
<gi>gap</gi> tag should be employed to signal that text cannot be
transcribed, with the value of the <att>reason</att> attribute giving
the cause for the omission from the transcription as deletion.  If it
is not fully legible, the <gi>unclear</gi> element (available when
using the additional tagset for transcription of primary sources)
should be used to signal the areas of text which cannot be read with
confidence.  See further sections <xref target="PHOM"> and, for the
close association of the <gi>del</gi> tag with the <gi>gap</gi>,
<gi>damage</gi>, <gi>unclear</gi> and <gi>supplied</gi> elements (the
latter three tags available when using the additional tagset for
transcription of primary sources), <xref target="PHCOMB">.</p>
<p>The <gi>del</gi> tag should not be used for deletions made by
editors or encoders.  In these cases, either the <gi>corr</gi> tag or
the <gi>gap</gi> tag should be used.</p></remarks>
 
<part type="top" name="core">
<classes names="EDIT">
<dataDesc>May contain character data and phrase-level elements.</dataDesc>
<elemDecl>- -  (%phrase.seq;)
</elemDecl>
<xref target="COEDADD" type="div3">
</tagDoc>
 
<?tei:EOF del.tag ?>
