<?tei:SOF delspan.tag ?>
<!-- $Id: delspan.tag,v 1.6 98/01/28 19:22:39 tei Exp $ -->
<!--*
    * $Log:	delspan.tag,v $
# Revision 1.6  98/01/28  19:22:39  tei
# LB changes of 1998-01
# 
    * Revision 1.5  1994/08/29  15:20:05  msmcq
    * fixes for unreachability
    * (divGen et al.)
    * 
    * Revision 1.4  1994/03/25  16:13:30  msmcq
    * restore changes overwritten by version 1.3,
    * change #inherited to %inherited
    * 
    * Revision 1.2  1994/03/08  03:24:27  msmcq
    * revision for P3
    * 
    * Revision 1.1  1993/08/03  02:27:04  msmcq
    * tagdoc files:  resynching uicvm and onions
    *-->
<!-- Revisions:                                               -->
<!-- 4 Jan 98: LB : changed class membership from edit to editincl -->
<!-- 4 Jan 98: LB : replaced refs to <omit> by refs to <gap>  -->
<!-- 94-08-04 : MSM : correct classes element                 -->
<!-- 94-08-04 : MSM : fix REACH:  make member of EDIT         -->
<!-- 94-03-21 : MSM : correct 'inherited' error               -->
<!-- 94-03-07 : MSM : change DESC as per CH suggestion        -->
<!-- 94-03-03 : MSM : fix GI in examples                      -->
<!-- 94-03-03 : MSM : fix ANCHOR in example                   -->
<!-- 93-06-05 : MSM : clear up bad comment                    -->
<!-- ENTITY delspan  system 'delspan.tag' --> <!-- delSpan tag -->
<!-- *********************************************** delSpan -->
<tagDoc id="DELSPAN" usage="opt">
<gi>delSpan</gi>
<name>deleted span of text</name>
<desc>marks the beginning of a longer sequence of text deleted,
marked as deleted, or otherwise signaled as superfluous or spurious by an
author, scribe, annotator, or corrector.</desc>
<attList>
<!-- ................................................... type -->
<attDef usage="opt">
<attName>type</attName>
<desc>classifies the deletion, using any convenient typology.</desc>
<datatype>CDATA</datatype>
<valList type="open">
<val>overstrike</val>
<desc>deletion indicated by line crossing out the text.</desc>
<val>erasure</val>
<desc>deletion indicated by erasure of the text.</desc>
<val>bracketed</val>
<desc>deletion indicated by brackets in the text or margin.</desc>
<val>subpunction</val>
<desc>deletion indicated by dots beneath the letters deleted.</desc>
</valList>
<default>#IMPLIED</default>
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... resp -->
<attDef usage="opt">
<attName>resp</attName>
<name>responsible</name>
<desc>signifies the editor or transcriber responsible for identifying
the hand of the deletion.</desc>
<datatype>IDREF</datatype>
<valDesc>must be one of the identifiers declared in the document
header, associated with a person asserted as responsible for some
aspect of the text's creation, transcription, editing or encoding
(see chapter <xref target="CE">).</valDesc>
<default>%INHERITED</default>
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... cert -->
<attDef usage="opt">
<attName>cert</attName>
<name>certainty</name>
<desc>signifies the degree of certainty ascribed to the
identification of the hand of the deletion.</desc>
<datatype>CDATA</datatype>
<default>#IMPLIED</default>
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ................................................... hand -->
<attDef usage="opt">
<attName>hand</attName>
<desc>signifies the hand of the agent which made the deletion.</desc>
<datatype>IDREF</datatype>
<valDesc>must be one of the hand identifiers declared in the document
header (see section <xref target="PHDH">).</valDesc>
<default>%INHERITED</default>
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<!-- ..................................................... to -->
<attDef usage="req">
<attName>to</attName>
<desc>identifies the endpoint of the deleted passage, by giving the
ID
of an <gi>anchor</gi> or other element placed there.</desc>
<datatype>IDREF</datatype>
<valDesc>any valid SGML identifier, used on a later element.</valDesc>
<default>#REQUIRED</default>
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>Both the beginning and the end of the deleted material
must
be marked; the beginning by the <gi>delSpan</gi> element itself, the
end by the <att>to</att> attribute.  The element pointed at by
<att>to</att> is understood to be included within the deleted
passage.</p></remarks>
</attDef>
<!-- ................................................. status -->
<attDef usage="opt">
<attName>status</attName>
<desc>indicates whether the deletion is faulty, e.g. by including too
much or too little text.</desc>
<datatype>CDATA</datatype>
<valList type="open">
<val>excess start</val>
<desc>some text at the beginning of the deletion is marked as
deleted even though it clearly should not be deleted.</desc>
<val>excess end</val>
<desc>some text at the end of the deletion is marked as
deleted even though it clearly should not be deleted.</desc>
<val>short start</val>
<desc>some text at the beginning of the deletion is not marked as
deleted even though it clearly should be.</desc>
<val>short end</val>
<desc>some text at the end of the deletion is not marked as
deleted even though it clearly should be.</desc>
<val>unremarkable</val>
<desc>the deletion is not faulty.</desc>
</valList>
<default>'unremarkable'</default>
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>
<!-- have replaced 'right' and 'left' with 'start' and 'end',  -->
<!-- which are less ambiguous in the case of vertical writing.  -MSM --></p>
<p>Marking a deletion as faulty is inescapably an interpretive act;
the usual test applied in practice is the linguistic acceptability of
the text with and without the letters or words in question.</p></remarks>
</attDef>
<!-- ................................................. length -->
<!-- < remarks >  < p > [Concerning length attribute on       -->
<!-- delSpan: Not clear to me why this is provided on  < gi   -->
<!-- > del.span < /gi > instead of on  < gi > omit < /gi >    -->
<!-- or  < gi > unclear < /gi > .  Suggest dropping it.       -->
<!-- -MSM                                                     -->
<!-- I agree.  Have deleted this attribute: it should be on   -->
<!-- OMIT and by definition cannot appear on DEL or its       -->
<!-- relatives -PR]                                           -->
</attList>
<exemplum><eg><![ CDATA [
<p>Paragraph partially deleted.  This is the undeleted
portion <delSpan resp=author to=a23>and this the deleted
portion of the paragraph.
<p>Paragraph deleted together with neighboring material.
<p>Second fully deleted paragraph.
<p>Paragraph partially deleted; in the middle of this
paragraph the deletion ends and the anchor point marks
the resumption <anchor id=A23> of the text. ...
]]>
</eg></exemplum>
<remarks><p>Both the beginning and ending of the deleted sequence
must be marked:  the beginning by the <gi>delSpan</gi> element, the
ending by the target of the <att>to</att> attribute.</p>
<p>The text deleted must be at least partially legible, in order for
the encoder to be able to transcribe it.  If it is not legible at
all, the <gi>delSpan</gi> tag should not be used.  Rather, the
<gi>gap</gi> tag should be employed to signal that text cannot be
transcribed, with the value of the <att>reason</att> attribute giving
the cause for the omission from the transcription as deletion.  If it
is not fully legible, the <gi>unclear</gi> element should be used to
signal the areas of text which cannot be read with confidence.  See
further sections <xref target="PHOM"> and, for the close association of
the <gi>delSpan</gi> tag with the <gi>gap</gi>, <gi>damage</gi>,
<gi>unclear</gi> and <gi>supplied</gi> elements, <xref target="PHCOMB">.</p>
<p>The <gi>delSpan</gi> tag should not be used for deletions made by
editors or encoders.  In these cases, either the <gi>corr</gi> tag or
the <gi>gap</gi> tag should be used.</p></remarks>
<part type="top" name="tc">
<classes names="EDITINCL">
<dataDesc>May contain character data and phrase-level elements.</dataDesc>
<elemDecl>- O  EMPTY
</elemDecl>
<xref target="PHAD">
</tagDoc>
<?tei:EOF delspan.tag ?>
