<?tei:SOF digraph.tag ?>
<!-- $Id: digraph.tag,v 1.1 93/08/03 02:27:04 msmcq Exp $ -->
<!-- $Log:	digraph.tag,v $
# Revision 1.1  93/08/03  02:27:04  msmcq
# tagdoc files:  resynching uicvm and onions
#  -->
<!-- Revisions:                                               -->
<!-- 93-06-04 : MSM : Fixed vallist semi                      -->
<!-- ************************************************************* -->
<!-- TAGDOC for DIGRAPH                                           -->
<tagDoc id=DIGRAPH usage=rwa>
<gi>digraph</gi>
<name>Directed Graph or Digraph
<desc>encodes a digraph, which is a collection of nodes and arcs.
<attList>
<attDef id=DGORDER usage=opt>
<attName>order
<desc>gives the order of the digraph, i.e., the number of its nodes.
<datatype>NUMBER
<valDesc>A positive integer.
<default>#IMPLIED
</attDef>
<attDef id=DGSIZE usage=opt>
<attName>size
<desc>gives the size of the graph, i.e., the number of its arcs.
<datatype>NUMBER
<valDesc>A nonnegative integer.
<default>#IMPLIED
</attDef>
<attDef id=DGNDFRM usage=req>
<attName>nodeFrame
<desc>describes a frame for the nodes of the digraph.
<datatype>CDATA
<valList type=semi>
    <val>plain    <desc>No frame.
    <val>box      <desc>Box frame.
    <val>diamond  <desc>Diamond frame.
    <val>circle   <desc>Circular frame.
</valList>
<default>plain
</attDef>
<attDef id=DGARSPC usage=req>
<attName>arcSpec
<desc>specifies how the arcs of the digraph are to be drawn.
<datatype>CDATA
<valList type=semi>
    <val>solid           <desc>Solid line.
    <val>dotted          <desc>Dotted line.
    <val>dashed          <desc>Dashed line.
    <val>arrow           <desc>Solid line with arrowhead pointing to
adjacent node.
    <val>arrow2head      <desc>Solid line with double arrowhead pointing
to adjacent node.
    <val>'double arrow'  <desc>Solid double line with arrowhead pointing
to adjacent node.
    <val>'dashed arrow'  <desc>Dashed line with arrowhead pointing to
adjacent node.
    <val>'curved arrow'  <desc>Curved line with arrowhead pointing to
adjacent node.
</valList>
<default>arrow
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
<digraph id=D1 order=5 size=5 nodeFrame=plain arcSpec=arrow>
   <node label=u id=D1U inDegree=1 outDegree=1>
   <node label=v id=D1V inDegree=1 outDegree=1>
   <node label=w id=D1W inDegree=2 outDegree=2>
   <node label=x id=D1X inDegree=1 outDegree=1>
   <node label=y id=D1Y inDegree=0 outDegree=0>
   <arc id=D1U.v from=d1u to=d1v>
   <arc id=D1V.w from=d1v to=d1w>
   <arc id=D1W.u from=d1w to=d1u>
   <arc id=D1W.x from=d1w to=d1x>
   <arc id=D1X.w from=d1x to=d1w>
   </digraph>
]]>
</eg>
</exemplum>
<part type=top name=ling><classes>
<dataDesc>One or more nodes and zero or more arcs in any order.
<elemDecl>- - ((node)+ & (arc)*)</elemDecl>
<xref target=GDDI>
</tagDoc>
<?tei:EOF digraph.tag ?>
