<?tei:SOF directn.tag ?>
<!-- $Id: directn.tag,v 1.2 94/01/04 12:14:06 lou Exp $ -->
<!-- $Log:	directn.tag,v $
# Revision 1.2  94/01/04  12:14:06  lou
# fix xrefs
# 
# Revision 1.1  1993/08/03  02:27:04  msmcq
# tagdoc files:  resynching uicvm and onions
# -->
<!-- ********************************************** direction -->
<tagDoc id=DIRECTN usage=rec>
<gi>direction</gi>
<desc>specifies one or more conventional directions in which a language
is written using a given script.
<attList>
<!-- .................................................. chars -->
<attDef usage=req>
<attName>chars
<name>characters
<desc>indicates the order in which characters within a line are
conventionally presented in this writing system
<datatype>CDATA
<valList type=semi>
<val>LR <desc>left to right
<val>RL <desc>right to left
<val>TB <desc>top to bottom
<val>BT <desc>bottom to top
</valList>
<default>#REQUIRED
<remarks><p>If the characters follow each other in some order other than
top-to-bottom, bottom-to-top, left-to-right, or right-to-left, then some
value other than those indicated should be used.
</remarks>
</attDef>
<!-- .................................................. lines -->
<attDef usage=req>
<attName>lines
<desc>indicates the order in which lines conventionally follow each
other in this writing system.
<datatype>CDATA
<valList type=semi>
<val>TB <desc>top to bottom
<val>BT <desc>bottom to top
<val>LR <desc>left to right
<val>RL <desc>right to left
</valList>
<default>#REQUIRED
<remarks><p>If the lines follow each other in some order other than
top-to-bottom, bottom-to-top, left-to-right, or right-to-left, then some
value other than those indicated should be used.
</remarks>
</attDef>
</attList>
<exemplum><eg><![ CDATA [
<eclaration lang=eng id='DEU'
 name='-//TEI P2: 1993//WSD Modern German//en' date='1993-06-01'>
 <language iso639='deu'>New High German</language>
 <script>Latin script with diacritics.</script>
 <direction chars='LR' lines='TB'>
 <!-- ... -->
</eclaration>
]]>
</eg></exemplum>
<exemplum>
<p>If more than one direction is specified, it means that the script in
question may be written in any of the directions named.  In some cases,
the directions may be mixed within a single document, in others not; no
information is given on this point by the writing system declaration, as
it is not usefully formalizable.  Experts on the script must be
consulted for details.  The following example shows one way to declare
that a script may be written in any horizontal or vertical
direction.</p>
<eg><![ CDATA [
<eclaration lang=eng id=JPN
 name='-//TEI P2: 1993//WSD JIS 0208//en' date='1993-06-01'>
 <language iso639='jpn'>Modern Japanese</language>
 <script>normal Japanese writing, with mixture of hiragana,
         katakana, and kanji.</script>
 <direction chars='LR' lines='TB'>
 <direction chars='RL' lines='TB'>
 <direction chars='LR' lines='BT'>
 <direction chars='RL' lines='BT'>
 <direction chars='TB' lines='LR'>
 <direction chars='BT' lines='LR'>
 <direction chars='TB' lines='RL'>
 <direction chars='BT' lines='RL'>
 <!-- Japanese can, in effect, be written in any direction. -->
 <!-- Individual documents may, but need not, mix the       -->
 <!-- various directions.                                   -->
 <!-- ... -->
</eclaration>
]]>
</eg></exemplum>
<exemplum>
<p>The following example shows another way to specify that a script may
be written in any horizontal or vertical direction.</p>
<eg><![ CDATA [
<eclaration lang=eng id=JPN
 name='//TEI P2: 1993//WSD JIS 0208//en' date='1993-06-01'>
 <language iso639='jpn'>Modern Japanese</language>
 <script>normal Japanese, with mixture of hiragana, katakana,
         and kanji.</script>
 <direction chars='LR RL' lines='TB BT'>
 <direction chars='TB BT' lines='LR RL'>
 <!-- Japanese can, in effect, be written in any direction. -->
 <!-- Individual documents may, but need not, mix the       -->
 <!-- various directions.                                   -->
 <!-- ... -->
</eclaration>
]]>
</eg></exemplum>
<exemplum>
<p>In some cases, the <att>lines</att> and <att>chars</att> attributes
may need to take special values.  Some scripts are written in
<soCalled>boustrophedon</soCalled> (turning back and forth):  i.e. one
line is written left to right, the next right to left, and so on.  Such
a writing system might have its direction declared as shown:</p>
<eg><![ CDATA [
 <direction chars='boustrophedon:  LR, then RL, then LR, etc.'
            lines='TB'>
]]>
</eg></exemplum>
 
<remarks><p>This element describes conventional presentation; all
scripts are subject to unusual treatment in special circumstances, and
such unusual directions need not be described here.  The treatment of
numerals in Latin, Hebrew, and Arabic script, being well understood,
need not be documented separately here.<note place=foot>Although the
scripts run in opposite directions, they write numbers in the same
direction; the usual view is that the numbers in Hebrew and Arabic run
left to right, like those in Latin script, but it is also possible to
claim that the numbers in Latin scripts run right to left, like those in
Arabic and Hebrew.  There is no single satisfactory answer to this
question.</note>
 
<p>The <gi>direction</gi> element is informational only, not normative.
It is intended to alert those responsible for implementing support for a
given writing system to an essential fact of how it is written.  If only
a single direction is specified, it is safe to infer that the script may
legitimately be presented in that direction.  If multiple directions are
specified, it may be legitimate to present text in any one of them, or
it may be necessary to support multiple directions in display of a
single document.  If the latter, then changes of direction should be
given using the global <att>rend</att> attribute.
 
<p>If no direction element is given, the only safe assumption is that
any direction is possible and experts must be consulted before
attempting to implement support for the writing system.
 
</remarks>
<part type=aux name=wsd>
<classes>
<dataDesc>Empty.
<elemDecl>- O  EMPTY
</elemDecl>
<xref target=WDWS>
<xref target=WDOV>
</tagDoc>
<?tei:EOF directn.tag ?>
