<?tei:SOF expan.tag ?>
<!-- $Id: expan.tag,v 1.3 1998/02/09 14:30:22 tei Exp $ -->
<!--*
    * $Log: expan.tag,v $
    * Revision 1.3  1998/02/09 14:30:22  tei
    * fixing egs....
    *
    * Revision 1.2  94/01/04  12:14:26  lou
    * fix xrefs
    * 
    * Revision 1.1  1993/06/23  11:28:40  lou
    * Initial checkin
    * -->
<!-- Revisions:                                               -->
<!-- 92-12-09 : MSM : suppress membership in edit class       -->
<!-- 92-11-09 : MSM : supply missing end-tag for gi           -->
<!-- ******************************************************* expan --
>
<tagDoc id=EXPAN usage=opt>
<gi>expan</gi>
<name>expansion
<desc>contains the expansion of an abbreviation.
<attList>
<attDef usage=opt>
<attName>abbr
<name>abbreviation
<desc>gives the abbreviation in its unexpanded form.
<datatype>CDATA
<valDesc>any string of characters
<default>#IMPLIED
<eg><![ CDATA [
 The address is Southmoor <expan abbr='Rd'>Road</expan>.
]]>
</eg>
</attDef>
<attDef usage=opt>
<attName>resp
<name>responsibility
<desc>signifies the editor or transcriber responsible for supplying 
the expansion of the abbreviation held as the content of the 
<gi>expan</gi> element.
<datatype>IDREF
<valDesc>must be one of the identifiers declared in the document 
header, associated with a person asserted as responsible for some 
aspect of the text's creation, transcription, editing or encoding 
(see chapter <xref target=CE>).
<default>%INHERITED
<eg><![ CDATA [
 The address is Southmoor <expan abbrev='Rd' resp=LB>Road</>.
]]>
</eg>
</attDef>
<!-- ................................................... cert -->
<attDef usage=opt>
<attName>cert
<name>certainty
<desc>signifies the degree of certainty ascribed to the expansion of 
the abbreviation.
<datatype>CDATA
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
</attDef>
<attDef usage=opt>
<attName>type
<desc>allows the encoder to classify the abbreviation according to 
some
convenient typology.
<datatype>CDATA
<valDesc>any useful classification name, e.g. <q>suspension</q>,
<q>contraction</q>, <q>brevigraph</q>, <q>title</q>,
<q>organization</q>, <q>geographic</q>, etc.
<default>#IMPLIED
<eg><![ CDATA [
]]>
</eg>
 
<remarks><p>The <att>type</att> attribute is provided for the sake of
those who wish to classify abbreviations at their point of  occurrence;
this may be useful in some circumstances, though usually the same
abbreviation will have the same type in all occurrences.  As the 
sample values make clear, abbreviations may be classified by the method
used  to construct them, the method of writing them, or the referent of
the  term abbreviated; the typology used is up to the encoder and
should be carefully planned to meet the needs of the expected use.
</attDef>
</attList>
<exemplum><eg><![ CDATA [
]]>
</eg></exemplum>
<remarks><p>This tag is the mirror image of the <gi>abbr</gi> tag; 
both allow the encoder to transcribe both an abbreviation and its 
expansion. In <gi>abbr</gi>, however, the original is transcribed as
the content  of the element and the expansion as an attribute value;
<gi>expan</gi> reverses this.	The choice between the two is up to the
user. <p>The <gi>expan</gi> tag is not required; if appropriate, the 
encoder may expand abbreviations in the source text silently, without
tagging them.  If this is done, the TEI header should so indicate.
<part type=top name=core>
<classes names="DATA">
<dataDesc>May contain character data and phrase-level elements.
<elemDecl>- - (%phrase.seq;)
</elemDecl>
<xref type=div3 target=CONAAB>
</tagDoc>
 
<?tei:EOF expan.tag ?>
