<?tei:SOF f.tag ?>
<!-- ************************************************************ -->
<!-- TAGDOC for F                                                 -->
<!-- $Id: f.tag,v 1.3 94/01/04 00:39:28 msmcq Exp $ -->
<!-- $Log:	f.tag,v $
# Revision 1.3  94/01/04  00:39:28  msmcq
# change model (DFT name clash)
# 
# Revision 1.2  1993/09/23  02:38:58  msmcq
# Unpacked TDL changes of July 93
# -->
<!-- Revisions:                                               -->
<!-- 94-01-03 : MSM : change elemdecl:  dft, not default      -->
<!-- 93-12-20 : MSM : add valdesc                             -->
<!-- 93-09-22 : MSM : extract from bulk revision file         -->
<!-- ************************************************************ -->
<tagDoc id=F usage=rwa>
<gi>f</gi>
<name>Feature
<desc>associates a name with a value of any of several different types.
<attList>
<attDef id=FNAME usage=req>
<attName>name
<desc>provides a name for a feature.
<datatype>NMTOKEN
<valDesc>A name token.
<default>#REQUIRED
</attDef>
<attDef id=FORG usage=rwa>
<attName>org
<desc>indicates organization of given value or values as singleton, set,
bag or list.
<datatype>(single|set|bag|list)
<valList type=closed>
   <val>single <desc>indicates that the given value is a singleton.
   <val>set    <desc>indicates that the given values are organized as a
set.
   <val>bag    <desc>indicates that the given values are organized as a
bag (multiset).
   <val>list   <desc>indicates that the given values are organized as a
list.
</valList>
<default>#IMPLIED
<remarks><p>If the <att>org=single</att> attribute value is specified and
more than one value for the feature is given, then only the first value
is used.
</attDef>
<attDef id=FREL usage=req>
<attName>rel
<desc>indicates the relation between the values that are given as the
content of the feature or pointed at by the <att>fVal</att> attribute and
the actual values of the feature.
<datatype>(eq|ne|sb|ns)
<valList type=closed>
   <val>eq     <desc>indicates that the given values are the actual
values.
   <val>ne     <desc>indicates that the given values are not the actual
values.
   <val>sb     <desc>indicates that the given values are a subset, subbag
or sublist of the actual values.
   <val>ns     <desc>indicates that the given values are not a subset,
subbag or sublist of the actual values.
</valList>
<default>eq
<remarks><p>If <att>org=single</att>, then <att>rel=sb</att> is
equivalent to <att>rel=eq</att>, and <att>rel=ns</att> is equivalent to
<att>rel=ne</att>.
</attDef>
<attDef id=FFVAL usage=opt>
<attName>fVal
<desc>points to the <att>id</att> attributes of feature values.
<datatype>IDREFS
<valDesc>one or more legal SGML identifiers.
<default>#IMPLIED
<remarks><p>May be used instead of content.
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
<f name=gender><sym value=feminine></f>
]]>
</eg>
</exemplum>
<remarks><p>If content is empty and no <att>fVal</att> attribute is
present, then value is that specified by <gi>default</gi>.
<p>Content is defined as (null | (%mVal;)*) in FS3.dtd.
The entity %mVal; is defined as "%aVal; | %dVal;" in FS3.dtd.
%aVal; is defined as "plus | minus | any | none | dft | uncertain".
%dVal; is defined as "%cVal; | fs".
Finally, %cVal; is defined as "sym | nbr | msr | rate | str | vAlt |
alt",
<part type=top name=fs>
<classes>
<dataDesc>Exactly one null value, or zero or more values other than null.
<elemDecl>- O (null | (plus | minus | any | none | dft | uncertain |
sym | nbr | msr | rate | str | vAlt | alt | fs)*)</elemDecl>
<xref type=div3 target=FSBI>
</tagDoc>
<?tei:EOF f.tag ?>
