<?tei:SOF fstag.tag ?>
<!-- ************************************************************ -->
<!-- TAGDOC for FS                                                -->
<!-- $Id: fstag.tag,v 1.5 94/08/29 15:23:27 msmcq Exp $ -->
<!-- $Log:	fstag.tag,v $
# Revision 1.5  94/08/29  15:23:27  msmcq
# Changes for unreachability bugs
# 
# Revision 1.4  1994/04/08  01:52:06  msmcq
# Last fixes for FD in P3, etc.
#
# Revision 1.3  1994/01/04  00:43:51  msmcq
# change descriptions of REL values
#
# Revision 1.2  1993/09/23  02:38:58  msmcq
# Unpacked TDL changes of July 93
# -->
<!-- Revisions:                                               -->
<!-- 94-08-04 : MSM : fix FSINFO, make member of METADATA     -->
<!-- 94-04-07 : MSM : add to class cplxval                    -->
<!-- 94-04-07 : MSM : comment out remarks                     -->
<!-- 93-12-22 : MSM : change descriptions on REL att values   -->
<!-- 93-09-22 : MSM : extract from bulk revision              -->
<!-- ************************************************************ -->
<tagDoc id=FSTAG usage=rwa>
<gi>fs</gi>
<name>Feature structure
<desc>analyzes a collection of features and feature alternations as a
structural unit.
<attList>
<attDef id=FSTYPE usage=rwa>
<attName>type
<desc>provides a type for a feature structure.
<datatype>CDATA
<valDesc>Character string, e.g. <term>word structure</term>.
<default>#IMPLIED
</attDef>
<!-- why can't we call this 'features'? (msm) -->
<attDef id=FSFEATS usage=opt>
<attName>feats
<desc>pointer to features.
<datatype>IDREFS
<valDesc>list of individual IDs for features.
<default>#IMPLIED
<remarks><p>May be used instead of having features as content.
</attDef>
<attDef id=FSREL usage=opt>
<attName>rel
<desc>indicates the relation of the given content to the actual content
or value of the feature structure.
<datatype>(eq|ne|sb|ns)
<valList type=closed>
   <val>eq     <desc>indicates that the actual content is that given.
   <val>ne     <desc>indicates that the actual content is not that given.
   <val>sb     <desc>indicates that the actual content is subsumed by the
given content.
   <val>ns     <desc>indicates that the actual content is not subsumed by
the given content.
</valList>
<default>sb
<remarks><p>The <gi>fs</gi> element is the only one for which the default
<att>rel</att> attribute value is <term>sb</term>.  For all others, it is
<term>eq</term>.
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
<fs type='agreement structure' rel=ns>
   <f name=person><sym value=third></f>
   <f name=number><sym value=singular></f>
   </fs>
]]>
</eg>
</exemplum>
<!-- <remarks><p>The entity %fFamily; is defined as "f |      -->
<!-- fAlt" in FS3.dtd.                                        -->
<part type=top name=fs>
<classes names="CPLXVAL METADATA">
<dataDesc>Zero or more features or (feature) alternations.
<elemDecl>- - ((f | fAlt | alt)*)</elemDecl>
<xref type=div3 target=FSBI>
</tagDoc>
<?tei:EOF fstag.tag ?>
