<?tei:SOF gram.tag ?>
<!-- $Id: gram.tag,v 1.6 98/01/28 19:22:39 tei Exp $ -->
<!--*
    * $Log:	gram.tag,v $
# Revision 1.6  98/01/28  19:22:39  tei
# LB changes of 1998-01
# 
    * Revision 1.5  1994/03/21  14:33:08  lou
    * second major typo purge
    * 
    * Revision 1.4  1994/03/07  16:15:59  lou
    * typos spotted by DTB
    * 
    * Revision 1.3  1994/01/15  20:53:57  msmcq
    * msmcq revision of DI for P3.  Consult comments for details.
    * 
    * Revision 1.2  1994/01/04  12:14:29  lou
    * fix xrefs
    * 
    * Revision 1.1  1993/06/23  11:28:40  lou
    * Initial checkin
    *-->
<!-- Revisions:                                               -->
<!-- 4 Jan 98 : LB :  change  type= on vallist for TYPE       -->
<!-- 94-01-14 : MSM : Added class membership in diglobal      -->
<!-- 94-01-12 : MSM : add to morph class                      -->
<!-- 94-01-12 : MSM : add mention of use in dictionaries      -->
<!-- 92-12-23 : MSM : expand TC37dd entity                    -->
<!-- 92-12-18 : MSM : remove FLATTERM class                   -->
<!-- 92-12-18 : MSM : added number, animate, and proper as TYPE vals -->
<!-- 92-11-23 : MSM : define default                          -->
<!-- 92-11-23 : MSM : added end-tag for gi                    -->
<!-- *************************************************** gram -->
<tagDoc id="GRAM" usage="opt">
<gi>gram</gi>
<name>grammatical information</name>
<desc>within an entry in a dictionary or a terminological data file,
contains grammatical information relating to a term, word, or form.</desc>
<attList>
<!-- ................................................... type -->
<attDef usage="opt">
<attName>type</attName>
<desc>classifies the grammatical information given according to some
convenient typology --- in the case of terminological information,
preferably the dictionary of data element types
specified in ISO WD 12 620.</desc>
<datatype>CDATA</datatype>
<valList>
    <val>pos</val>
    <desc>part of speech (any of the word classes to which a word may
be assigned in a given language, based on form, meaning, or a
combination of features, e.g. noun, verb, adjective, etc.)</desc>
    <val>gen</val>
    <desc>gender (formal classification by which nouns and pronouns, and
often accompanying modifiers, are grouped and inflected, or changed in
form, so as to control certain syntactic relationships)</desc>
    <val>num</val>
    <desc>number (e.g. singular, plural, dual, ...)</desc>
    <val>animate</val>
    <desc>animate or inanimate</desc>
    <val>proper</val>
    <desc>proper noun or common noun</desc>
</valList>
<default>#IMPLIED</default>
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>A much fuller list of values for the <att>type</att>
attribute may be generated from the dictionary of data element types
under preparation as ISO TC 37/SC 3/WD 12 620, Computational Aids in
Terminology.  See ISO 12 620 for fuller details.</p></remarks>
</attDef>
</attList>
<exemplum><eg><![ CDATA [
 
]]>
</eg></exemplum>
<remarks><p>In terminological data,
the <gi>gram</gi> element usually refers to the most
recently specified <gi>term</gi> or <gi>otherForm</gi> element.  In
flat term entries, the <att>group</att> and <att>depend</att> attributes
may be used to indicate exceptions to this general rule.
In dictionaries, the element typically relates to the form or forms
with which it is grouped in a <gi>form</gi> or other grouping element.</p></remarks>
<part type="base" name="term">
<classes names="MORPH DIGLOBAL">
<dataDesc>May contain character data and phrase-level elements.</dataDesc>
<elemDecl>- O  (%paraContent;)
</elemDecl>
<xref target="TEDTF" type="div1">
<xref target="TETA" type="div1">
<xref target="DITPGR" type="div1">
</tagDoc>
<?tei:EOF gram.tag ?>
