<?tei:SOF graph.tag ?>
<!-- ********** GRAPH                                          -->
<!-- $Id: graph.tag,v 1.5 94/01/04 12:14:30 lou Exp $ -->
<!-- $Log:	graph.tag,v $
# Revision 1.5  94/01/04  12:14:30  lou
# fix xrefs
# 
# Revision 1.4  1993/09/22  19:09:25  msmcq
# As of chapter publication
#
# Revision 1.3  1993/09/15  22:56:03  msmcq
# Changes as of mid-September
# -->
<!-- Revisions:                                               -->
<!-- 93-09-17 : MSM : vallist semi > type=semi                -->
<!-- 93-09-17 : MSM : outDegr[ee   full word                  -->
<!-- 93-09-17 : MSM : inDegr[ee                               -->
<!-- 93-09-15 : MSM : cleanup, add RCS id                     -->
<!-- 93-09-10 : MSM : Normalize GI case                       -->
<!-- 93-07-23 : DTL : modify P2 version                       -->
<!--                  merge GRAPH and DIGRAPH tags            -->
<!--                  replace LABEL and FS content by         -->
<!--                      label= and value=                   -->
<!--                  add type= to distinguish among          -->
<!--                      types of graphs                     -->
<!--                  eliminate special drawing attributes    -->
<!--                      (use rend=)                         -->
<!-- ********** GRAPH                                          -->
<tagDoc id=GRAPH usage=rwa>
<gi>graph</gi>
<desc>encodes a graph, which is a collection of nodes, and arcs which
connect the nodes.
<attList>
<attDef id=GRTYPE usage=rec>
<attName>type
<desc>describes the type of graph.
<datatype>CDATA
<valList type=semi>
<val>undirected
<desc>undirected graph
<val>directed
<desc>directed graph
<val>transition network
<desc>a directed graph with distinguished initial and final nodes
<val>transducer
<desc>a transition network with up to two labels on each arc
</valList>
<default>#IMPLIED
<remarks><p>If <att>type=undirected</att>, then the distinction between
the <att>to</att> and <att>from</att> attributes of the <gi>arc</gi> tag
is neutralized.  Also, the <att>adj</att> attribute, rather than the
<att>adjFrom</att> and <att>adjTo</att> attributes, should be used to
encode pointers to the ends of the arcs.  If <att>type=directed</att>
(or any other value which implies directionality), then the
<att>adjFrom</att> and <att>adjTo</att> attributes should be used,
instead of the <att>adj</att> attribute.
</attDef>
<attDef id=GRLAB usage=rwa>
<attName>label
<desc>gives a label for a graph.
<datatype>CDATA
<valDesc>A character string.
<default>#IMPLIED
</attDef>
<attDef id=GRORDER usage=opt>
<attName>order
<desc>states the order of the graph, i.e., the number of its nodes.
<datatype>NUMBER
<valDesc>A positive integer.
<default>#IMPLIED
</attDef>
<attDef id=GRSIZE usage=opt>
<attName>size
<desc>states the size of the graph, i.e., the number of its arcs.
<datatype>NUMBER
<valDesc>A nonnegative integer.
<default>#IMPLIED
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
<graph type=undirected
       id=CUG1
       label='Airline Connections in Southwestern USA'
       rend='LABEL-PLACE bottom center NODE-FRAME none ARC solid line'
       order=5
       size=4>
  <node label=LAX id=LAX degree=2>
  <node label=LVG id=LVG degree=2>
  <node label=PHX id=PHX degree=3>
  <node label=TUS id=TUS degree=1>
  <node label=CIB id=CIB degree=0>
  <arc from=LAX to=LVG>
  <arc from=LAX to=PHX>
  <arc from=LVG to=PHX>
  <arc from=PHX to=TUS>
  </graph>
]]>
</eg></exemplum>
<exemplum><eg><![ CDATA [
<graph type=directed
       id=RDG2
       label='Selected Airline Routes in Southwestern USA'
       rend='LABEL-PLACE bottom center NODE-FRAME none ARC solid line
with arrowhead'
       order=5
       size=5>
   <node label=LAX id=LAX inDegree=1 outDegree=1 adjTo=LVG adjFrom=PHX>
   <node label=LVG id=LVG inDegree=1 outDegree=1 adjFrom=LAX adjTo=PHX>
   <node label=PHX id=PHX inDegree=2 outDegree=2 adjTo='LAX TUS'
         adjFrom='LVG TUS'>
   <node label=TUS id=TUS inDegree=1 outDegree=1 adjTo=PHX adjFrom=PHX>
   <node label=CIB id=CIB inDegree=0 outDegree=0>
   </graph>
]]>
</eg></exemplum>
<part type=top name=graphs><classes names=CHUNK>
<dataDesc>One or more nodes and zero or more arcs in any order.
<elemDecl>- - ((node)+ & (arc)*)</elemDecl>
<xref type=div1 target=GDGR>
</tagDoc>
<?tei:EOF graph.tag ?>
