<?tei:SOF inode.tag ?>
<!-- ********** InODE                                         -->
<!-- $Id: inode.tag,v 1.5 93/09/22 19:09:25 msmcq Exp $ -->
<!-- $Log:	inode.tag,v $
# Revision 1.5  93/09/22  19:09:25  msmcq
# As of chapter publication
# 
# Revision 1.4  1993/09/15  22:56:03  msmcq
# Changes as of mid-September
#
# Revision 1.3  1993/09/09  19:09:38  msmcq
# restore RCS id, log
# -->
<!-- Revisions:                                               -->
<!-- 93-09-17 : MSM : outDegr[ee   full word                  -->
<!-- 93-09-15 : MSM : cleanup                                 -->
<!-- 93-09-10 : MSM : Normalize GI case                       -->
<!-- 93-07-23 : DTL : modify P2 version                       -->
<!--                   replace LABEL and FS content by        -->
<!--                       value= and label=                  -->
<!--                   eliminate special drawing attributes   -->
<!--                       (use rend=)                        -->
<!-- ********** InODE                                         -->
<tagDoc id=INODE usage=rwa>
<gi>iNode</gi>
<name>intermediate (or internal) node
<desc>represents an intermediate (or internal) node of a tree.
<attList>
<attDef id=INLAB usage=opt>
<attName>label
<desc>gives a label for an intermediate node.
<datatype>CDATA
<valDesc>A character string.
<default>#IMPLIED
</attDef>
<attDef id=INVALUE usage=rwa>
<attName>value
<desc>provides the value of an intermediate node, which is a feature
structure or other analytic element.
<datatype>IDREF
<valDesc>A valid identifier of a feature structure or other analytic
element.
<default>#IMPLIED
</attDef>
<attDef id=INCHILD usage=req>
<attName>children
<desc>provides a list of IDs of the elements which are the children of
the intermediate node.
<datatype>IDREFS
<valDesc>A list of IDs.
<default>#REQUIRED
</attDef>
<attDef id=INPAR usage=opt>
<attName>parent
<desc>provides the ID of the element which is the parent of this node.
<datatype>IDREF
<valDesc>The ID of the parent node.
<default>#IMPLIED
</attDef>
<attDef id=INORD usage=opt>
<attName>ord
<desc>indicates whether or not the internal node is ordered.
<datatype>(Y | N)
<valList type=closed>
<val>Y
<desc>indicates that the children of the intermediate node are ordered.
<val>N
<desc>indicates that the children of the intermediate node are unordered.
</valList>
<default>#IMPLIED
<remarks><p>Use if and only if <att>ord=partial</att> is specified on the
<gi>tree</gi> tag and the intermediate node has more than one child.
</attDef>
<attDef id=INFOL usage=rwa>
<attName>follow
<desc>provides an ID of the element which this node follows.
<datatype>IDREF
<valDesc>An ID of another intermediate node or leaf of the tree.
<default>#IMPLIED
<remarks><p>If the tree is unordered or partially ordered, this attribute
has the property of fixing the relative order of the intermediate node
and the element which is the value of the attribute.
</attDef>
<attDef id=INOUTDG usage=opt>
<attName>outDegree
<desc>gives the out degree of an intermediate node, the number of its
children.
<datatype>NUMBER
<valDesc>A nonnegative integer.
<default>#IMPLIED
<remarks><p>The in degree of an intermediate node is always 1.
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
<iNode label=PT id=PT1 parent=VB1 children=up1 outDegree=1 follow=PN1>
]]>
</eg>
</exemplum>
<part type=top name=graphs><classes>
<dataDesc>empty
<elemDecl>- O EMPTY</elemDecl>
<xref type=div2 target=GDTR>
</tagDoc>
<?tei:EOF inode.tag ?>
