<?tei:SOF join.tag ?>
<!-- $Id: join.tag,v 1.6 94/08/29 15:25:03 msmcq Exp $ -->
<!-- $Log:	join.tag,v $
# Revision 1.6  94/08/29  15:25:03  msmcq
# Changes for unreachability bugs
# 
# Revision 1.5  1994/03/16  03:45:14  msmcq
# revision of SA as per John Lavagnino
#
# Revision 1.4  1994/02/12  10:45:35  lou
# revns for publicn P3
#
# Revision 1.3  1994/01/14  18:37:54  lou
# fix typo (end of comment deimiter missing)
#
# Revision 1.2  1994/01/07  20:30:34  msmcq
# Merge Terry Langendoen's revisions of summer 1993
# rename PARTS as TARGETS as per Eynsham and DTL
# add INCL attribute to resolve a conundrum
#
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 94-08-04 : MSM : fix LINKINFO, make member of METADATA   -->
<!-- 94-03-15 : MSM : correct tagging slip                    -->
<!-- 94-03-15 : MSM : add DESC attribute                      -->
<!-- 94-03-15 : MSM : restore targRoot, renamed SCOPE         -->
<!--                  restore examples showing use of SCOPE   -->
<!-- 7 dec 94: LB commit murder on various attributes -->
<!-- 94-01-07 : MSM : accept DTL's renaming of PARTS as TARGETS -->
<!-- 94-01-07 : MSM : add targRoot attribute                  -->
<!-- 93-01-26 : MSM : change DESCs                            -->
<!-- ********************************************************** join -->
<tagDoc id=JOIN usage=opt>
<gi>join</gi>
<desc>identifies a possibly fragmented segment of text, by pointing
at the possibly discontiguous elements which compose it.
<attList>
<attDef usage=req>
<attName>targets
<desc>specifies the SGML identifiers of the elements or passages
       to be joined into a virtual element.</desc>
<datatype>IDREFS</datatype>
<valDesc>Each value specified must be the same as that specified as
    value for an <att>ID</att> attribute for some other element in the
    current SGML document.</valDesc>
<default>#REQUIRED
</attDef>
<attDef usage=opt>
<attName>result
<desc>specifies the name of an element
which this aggregation
may be understood to represent.</desc>
<datatype>NAME
<valDesc>The generic identifier of an element in the current DTD.
<default>%INHERITED
</attDef>
<!-- ................................................... desc -->
<attDef usage=opt>
<attName>desc
<name>description
<desc>a brief phrase describing the virtual element created by the join.
<datatype>CDATA
<valDesc>any string of characters.
<default>%INHERITED
<remarks><p>The <att>desc</att> attribute may be used to give a
brief description of the virtual element, if its content or function
are not obvious.
</attDef>
<!-- ............................. (targRoot, rootIncl) scope -->
<attDef usage=rec>
<attName>scope
<desc>indicates whether the targets to be joined include the
entire element indicated (the entire subtree including its root),
or just the children of the target (the branches of the subtree).
<datatype>(root | branches)
<valList type=closed>
<val>root <desc>the rooted subtrees indicated by the <att>targets</att>
attribute are joined, each subtree become a child of the virtual
element created by the <gi>join</gi>
<val>branches <desc>the children of the subtrees indicated by the
<att>targets</att> attribute become the children of the virtual element
(i.e. the roots of the subtrees are discarded)
</valList>
<default>root
<eg><![ CDATA [
 <list><head>Authors</head>
   <item id=UF>Figge, Udo
   <item id=CH>Heibach, Christiane
   <item id=GH>Heyer, Gerhard
   <item id=BP>Philipp, Bettina
   <item id=MS>Samiec, Monika
   <item id=SS>Schierholz, Stefan
 </list>
 <!-- elsewhere ...  -->
 <join result='list' targets='ch bp ss' scope=root
       desc='Heidelberger authors'>
]]>
</eg>
<!-- authors in Sprache und Datenverarbeitung 13.2 (1989).    -->
<remarks><p>In this example, the text contains a list of authors of
articles in a journal; the <gi>join</gi> element is used to
join into one virtual list the names of the authors who reside in
Heidelberg.
</attDef>
<attDef>
<attName>targOrder
<desc>specifies whether or not the order in which components of the
join are listed on the <att>targets</att> attribute is significant.
 <datatype>(Y | N | U)</datatype>
  <valList type=closed><val>Y<desc>Yes: the order
         should be followed when combining the
         targeted elements.
  <val>N <desc>No: the order
         has no significance when combining the
         targeted elements.
  <val>U <desc>Unspecified: the order
         may or may not be significant.
  </valList>
 <default>Y</default>
<remarks><p>This attribute has a different default value on this
element from that which it has for other members of the pointer
class.
</attDef>
</attList>
<!-- transplanted discussion to text (LB) -->
<exemplum><p>The following example is discussed in section
<xref target=SAAG>.</p>
<eg>
<![ CDATA [
 <sp who='Hughie'><p>How does it go?
   <q><l id=X1>da-da-da
      <l id=L2>gets a new frog
      <l>...
   </q></p>
 <sp who='Louie'><p><q><l id=L1>When the old pond</l> ...</q></p>
 <sp who='Dewey'><p><q>... <l id=L3>It's a new pond.</l></q></p>
 <!-- ... -->
 <join result=lg targets='L1 L2 L3' scope=root
       desc='haiku'>
 <!-- a famous haiku by Bashoo, in an eccentric translation -->
]]>
</eg>
<p>The attribute <att>targOrder</att> is specified with a
value of <q>Y</q> to indicate that the order of the three
lines is significant.  The attribute <att>scope</att> is
allowed to take the default value of <q>root</q> to
indicate that the virtual element being identified is a line
group (<gi>lg</gi>) which contains the three <gi>l</gi>
elements L1, L2, and L3, and not just their character data
content.
</exemplum>
<exemplum>
<p>In this example, the attribute <att>scope</att> is
specified with the value of <q>branches</q> to indicate that
the virtual list being constructed is to be made by taking the lists
indicated by the <att>targets</att> attribute of the <gi>join</gi>
element, discarding the <gi>list</gi> tags which enclose them, and
combining the items contained within the lists into a single virtual
list.
</p>
<eg><![ CDATA [
<s>Southern dialect (my own variety, at least) has only
<list id=LP1>
<item><s>I done gone</s></item>
<item><s>I done went</s></item>
</list>
whereas Negro Non-Standard basilect has both these and
<list id=LP2>
<item><s>I done go</s></item>.
</list></s>
<s>White Southern dialect also has
<list id=LP3>
<item><s>I've done gone</s></item>
<item><s>I've done went</s></item>
</list>
which, when they occur in Negro dialect, should probably be
considered as borrowings from other varieties of English.</s>
<!-- ... -->
<join result=list id=LST1 parts='lp1 lp2 lp3' scope=branches
      desc='Sample sentences in Southern speech'>
]]>
</eg>
</exemplum>
<part type=top name=links>
<classes names="POINTER METADATA">
<dataDesc>Empty element.
<elemDecl>- O EMPTY</elemDecl>
<xref type=div2 target=SAAG>
</tagDoc>
<?tei:EOF join.tag ?>
