<?tei:SOF loc.tag ?>
<!-- $Id: loc.tag,v 1.1 93/06/23 11:28:40 lou Exp $ -->
<!-- $Log:	loc.tag,v $
# Revision 1.1  93/06/23  11:28:40  lou
# Initial checkin
#  -->
<!-- Revisions:                                               -->
<!-- 93-02-10 : MSM : change target of xref                   -->
<!-- **************************************************** loc -->
<tagDoc usage=rec id="LOC"><gi>loc</gi>
<name>locus</name>
<desc>indicates one location within an alignment map either
relative to other locations on the same alignment, or absolutely.</desc>
<attList>
<attDef><attName>absolute</attName>
    <desc>supplies an absolute value for the location.</desc>
    <datatype>CDATA</datatype>
    <valDesc>Times may be given in standard form, as specified in
     the Encoding Declarations section of the header.</valDesc>
    <default>#IMPLIED</default>
<eg><![ CDATA [
<loc id=P1 absolute='12:20:02:02 CST'>
]]>
</eg>
<remarks></remarks>
</attDef>
<attDef><attName>since</attName>
    <desc>specifies the identifier of another location on the same
          alignment, relative to which the position of the current
          location is to be calculated.</desc>
    <datatype>IDREF</datatype>
    <valDesc>Must identify another location within the current alignment.
    </valDesc>
    <default>#IMPLIED</default>
    <remarks><p>If no value is supplied for this attribute, and the
     <att>interval</att> attribute on the alignment map is zero,
     then the base relative to which the position of the current location
     is to be calculated is the immediately preceding location within
     the alignment.</remarks>
</attDef>
<attDef><attName>id</attName>
    <name>identifier</name>
    <desc>supplies an arbitrary name, unique within the document,
used to identify the <gi>loc</gi>.</desc>
    <datatype>ID</datatype>
    <valDesc>any valid name</valDesc>
    <default>#REQUIRED</default>
    <remarks><p>IDs may be chosen freely; note in particular that if
they include numeric values there is no requirement for these to be in
sequence.</remarks>
</attDef>
<attDef><attName>distance</attName>
    <desc>specifies the position of a location within an alignment
     relative to that indicated by its <att>since</att> attribute
    in terms of the units specified by the <att>units</att>
   attribute of the enclosing alignment element.</desc>
    <datatype>NUMBER</datatype>
    <valDesc>any whole number</valDesc>
    <default>#IMPLIED</default>
<eg><![ CDATA [
<loc id=X1 since=X2 elapsed=334>
]]>
</eg>
    <remarks></remarks>
</attDef>
</attList>
<exemplum><eg>
<![ CDATA[
    <loc id=P43 elapsed=13 since=p42>
]]>
</eg></exemplum>
<remarks>
</remarks>
<part type=base name=ana>
<classes>
<dataDesc>may contain either nothing at all (in which case,
other parts of a text must be aligned by pointing into the alignment
map), or a series of pointer (<gi>ptr</gi>) elements (in which case,
alignment may be performed either by pointing into the text or by
double linkage) </dataDesc>
<elemDecl>- O (ptr*)</elemDecl>
<xref target="TSSAPA">
</tagDoc>
<?tei:EOF loc.tag ?>
