<?tei:SOF metdecl.tag ?>
<!-- Revisions:                                               -->
<!-- 21 jan 94: LB : change name to metdecl, add xref -->
<!-- 93-11-18 : MSM : remove ghost exemplum, eg, cdata starts -->
<!-- 93-11-18 : MSM : correct model:  paraSeq becomes component.seq -->
<!-- 93-11-18 : MSM : fix line break within Xref (script prob) -->
<!-- 93-11-18 : MSM : allow use for RHYME notation, add TYPE att -->
<!-- $Id: metdecl.tag,v 1.2 94/03/23 18:21:15 msmcq Exp $ -->
<!-- $Log:	metdecl.tag,v $
# Revision 1.2  94/03/23  18:21:15  msmcq
# correct errant spacing
# 
# Revision 1.1  1994/01/28  18:02:44  lou
# Initial revision
#
# Revision 1.2  1993/11/26  18:19:55  msmcq
# revision for publication of VE
#
# Revision 1.1  1993/08/11  13:11:14  lou
# Initial revision
# -->
<!-- 17 jul 93 : LB : made file -->
<!-- *************************************************** metDecl -->
<tagDoc id=METDECL usage=rec>
<gi>metDecl</gi>
<desc>documents the notation employed to represent a metrical pattern
when this is specified as the value of a <att>met</att>,
<att>real</att>, or <att>rhyme</att> attribute on any structural element
of a metrical text (e.g.  <gi>lg</gi>, <gi>l</gi>, or
<gi>seg</gi>).
<attList>
<!-- ................................................... type -->
<attDef usage=mwa>
<attName>type
<desc>indicates whether the notation conveys the abstract
metrical form, its actual prosodic realization, or the
rhyme scheme, or some combination thereof.
<datatype>NAMES
<valDesc>One or more of the three attribute names <att>met</att>,
<att>real</att>, or <att>rhyme</att>.
<default>"MET REAL"
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>By default, the <gi>metDecl</gi> element documents the
notation used for metrical pattern and realization.  It may also be used
to document the notation used for rhyme scheme information; if not
otherwise documented, the rhyme scheme notation defaults to the
traditional <q>abab</q> notation.
</attDef>
<attDef usage=opt>
<attName>pattern
<desc>specifies a regular expression defining any value that is
legal for this notation.
<datatype>CDATA
<valDesc>the value must be a valid expression for the PATTERN keyword
as defined in the TEI extended pointer notation
(see section <xref target=SAXR1PA>).
<default>#IMPLIED
<eg><![ CDATA [
 <metDecl pattern='( (1|0)+  \|? /? )* ' >
 <metDecl pattern= '((+-|-+)-+-+-+-+/)'
]]>
</eg>
<remarks>
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
   <metDecl id=IP pattern= '((+-|-+)-+-+-+-+/)'
        <symbol value='+'>stressed syllable
        <symbol value='-'>unstressed syllable
        <symbol value='/'>metrical line boundary
   </metDecl>
]]>
</eg>
<p>This example is intended for the far more restricted case
typified by the Shakespearean iambic pentameter. Only metrical patterns
containing exactly ten syllables, alternately stressed and unstressed,
(except for the first two which may be in either order) to each
metrical line can be expressed using this notation.
</exemplum>
<remarks><p>The encoder may choose whether to define the notation
formally or informally. However, the two methods may not be mixed.
<p>Only usable within the header if the verse base is enabled.
<part type=base name=hdr>
<classes names="DECLABL">
<dataDesc>contains either a sequence of <gi>symbol</gi> elements
or paragraphs. If one <gi>symbol</gi> is defined, then all the
codes appearing within the <att>pattern</att> attribute should
be documented, if the latter is specified.
<elemDecl>- O  ((%component.seq) | (symbol+))
</elemDecl>
<xref target=HDMN>
<xref target=VEME>
</tagDoc>
 
<?tei:EOF metdecl.tag ?>
