<?tei:SOF nbr.tag ?>
<!-- ************************************************************ -->
<!-- TAGDOC for NBR                                               -->
<!-- $Id: nbr.tag,v 1.5 94/04/08 01:52:06 msmcq Exp $ -->
<!-- $Log:	nbr.tag,v $
# Revision 1.5  94/04/08  01:52:06  msmcq
# Last fixes for FD in P3, etc.
# 
# Revision 1.4  1994/03/07  16:14:53  lou
# revised for publication
#
# Revision 1.3  1994/01/04  01:06:38  msmcq
# revise DESCs of REL values
#
# Revision 1.2  1993/09/23  02:38:58  msmcq
# Unpacked TDL changes of July 93
# -->
<!-- Revisions:                                               -->
<!-- 94-04-07 : MSM : add to class singval                    -->
<!-- 93-12-23 : MSM : change value, valueTo atts:  CDATA not NUMBER -->
<!-- 93-12-22 : MSM : change descriptions on REL att values   -->
<!-- 93-09-22 : MSM : extract from bulk file                  -->
<!-- ************************************************************ -->
<tagDoc id=NBR usage=rwa>
<gi>nbr</gi>
<name>Numeric value
<desc>provides a numeric value or range of values for a feature.
<attList>
<attDef id=NBRVAL usage=req>
<attName>value
<desc>provides a numeric value.
<datatype>CDATA
<valDesc>A real number or integer.
<default>#REQUIRED
</attDef>
<attDef id=NRVALTO usage=opt>
<attName>valueTo
<desc>together with <att>value</att> attribute, provides a range of
numeric values.
<datatype>CDATA
<valDesc>A real number or integer.
<default>#IMPLIED
</attDef>
<attDef id=NBRREL usage=req>
<attName>rel
<desc>indicates the relation of the given value or range to the actual
value or range.
<datatype>(eq|ne|lt|le|gt|ge)
<valList type=closed>
   <val>eq     <desc>indicates that the actual value or range is that
given.
   <val>ne     <desc>indicates that the actual value or range is not the
value or range given.
   <val>lt     <desc>indicates that the actual value or range is less
than the given value or range.
   <val>le     <desc>indicates that the actual value or range is less
than or equal to the given value or range.
   <val>gt     <desc>indicates that the actual value or range is greater
than the given value or range.
   <val>ge     <desc>indicates that the actual value or range is greater
than or equal to the given value or range.
</valList>
<default>eq
</attDef>
<attDef id=NBRTYPE usage=opt>
<attName>type
<desc>indicates whether value or range is to be understood as real or
integer.
<datatype>(int|real)
<valList type=closed>
   <val>int    <desc>specifies that value is an integer; if noninteger
is given as value of <att>value</att>, then only integer part is used.
   <val>real   <desc>specifies that value is a real number.
</valList>
<default>#IMPLIED
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
<nbr type=int rel=ge value=0>
]]>
</eg>
</exemplum>
<part type=top name=fs>
<classes names="SINGVAL">
<dataDesc>Empty tag.
<elemDecl>- O EMPTY</elemDecl>
<xref type=div3 target=FSSY>
</tagDoc>
<?tei:EOF nbr.tag ?>
