<?tei:SOF node.tag ?>
<!-- ********** NODE                                          -->
<!-- $Id: node.tag,v 1.6 94/01/04 12:14:44 lou Exp $ -->
<!-- $Log:	node.tag,v $
# Revision 1.6  94/01/04  12:14:44  lou
# fix xrefs
# 
# Revision 1.5  1993/09/22  19:10:59  msmcq
# changes for publication of GD
#
# Revision 1.4  1993/09/15  22:56:03  msmcq
# Changes as of mid-September
#
# Revision 1.3  1993/09/09  19:40:55  msmcq
# restore RCS id, log
# -->
<!-- Revisions:                                               -->
<!-- 93-09-17 : MSM : provide explicit att name for semi      -->
<!-- 93-09-17 : MSM : rename degr[ee], in, out                -->
<!-- 93-09-17 : MSM : add label2, for parallelism with ARC    -->
<!-- 93-09-15 : MSM : cleanup                                 -->
<!-- 93-09-10 : MSM : Normalize GI case                       -->
<!-- 93-07-23 : DTL : modify P2 version                       -->
<!--                  merge NODE and VERTEX tags              -->
<!--                  replace FS content by value=            -->
<!--                  eliminate LABEL content (retain label=) -->
<!--                  eliminate special drawing attributes    -->
<!--                      (use rend=)                         -->
<!-- ********** NODE                                          -->
<tagDoc id=NODE usage=rwa>
<gi>node</gi>
<desc>encodes a node, a possibly labeled point in a graph.
<attList>
<attDef id=NDLAB usage=opt>
<attName>label
<desc>gives a label for a node.
<datatype>CDATA
<valDesc>A character string.
<default>#IMPLIED
</attDef>
<attDef usage=opt>
<attName>label2
<desc>gives a second label for a node.
<datatype>CDATA
<valDesc>A character string.
<default>#IMPLIED
<remarks><p>Use this attribute together with the <att>label</att>
attribute if a transducer is being encoded whose actions are
associated with nodes rather than with arcs.
</attDef>
<attDef id=NDVALUE usage=opt>
<attName>value
<desc>provides the value of a node, which is a feature structure or
other analytic element.
<datatype>IDREF
<valDesc>A valid identifier.
<default>#IMPLIED
</attDef>
<attDef id=NDTYPE usage=opt>
<attName>type
<desc>provides a type for a node.
<datatype>CDATA
<valList type=semi>
<val>initial
<desc>initial node in a transition network
<val>final
<desc>final node in a transition network
</valList>
<default>#IMPLIED
</attDef>
<attDef id=NDADJTO usage=rwa>
<attName>adjTo
<desc>gives the IDs of the nodes which are adjacent to the current node.
<datatype>IDREFS
<valDesc>A list of IDs.
<default>#IMPLIED
</attDef>
<attDef id=NDADJFM usage=rwa>
<attName>adjFrom
<desc>gives the IDs of the nodes which are adjacent from the current
node.
<datatype>IDREFS
<valDesc>A list of IDs.
<default>#IMPLIED
</attDef>
<attDef id=NDADJ usage=rwa>
<attName>adj
<desc>gives the IDs of the nodes which are both adjacent to and
adjacent from the current node.
<datatype>IDREFS
<valDesc>A list of IDs.
<default>#IMPLIED
<remarks><p>Use this attribute instead of the <att>adjTo</att> and
<att>adjFrom</att> attributes when the graph is undirected and vice
versa if the graph is directed.
</attDef>
<attDef id=NDINDG usage=opt>
<attName>inDegree
<desc>gives the in degree of the node, the number of nodes which
are adjacent from the given node.
<datatype>NUMBER
<valDesc>A nonnegative integer.
<default>#IMPLIED
</attDef>
<attDef id=NDOUTDG usage=opt>
<attName>outDegree
<desc>gives the out degree of the node, the number of nodes which
are adjacent to the given node.
<datatype>NUMBER
<valDesc>A nonnegative integer.
<default>#IMPLIED
</attDef>
<attDef id=NDDG usage=opt>
<attName>degree
<desc>gives the degree of the node, the number of arcs with which
the node is incident.
<datatype>NUMBER
<valDesc>A nonnegative integer.
<default>#IMPLIED
<remarks><p>Use this attribute instead of the <att>inDegree</att> and
<att>outDegree</att> attributes when the graph is undirected and vice
versa if the graph is directed.
</attDef>
</attList>
<exemplum><eg>
<![ CDATA [
<node id=T6 label='6' inDegree=2 outDegree=0 type='final'>
]]>
</eg>
</exemplum>
<part type=top name=graphs><classes>
<dataDesc>empty
<elemDecl>- O EMPTY</elemDecl>
<xref type=div1 target=GDGR>
</tagDoc>
<?tei:EOF node.tag ?>
