<?tei:SOF note.tag ?>
<!-- $Id: note.tag,v 1.5 94/01/15 21:16:35 msmcq Exp $ -->
<!-- $Log:	note.tag,v $
# Revision 1.5  94/01/15  21:16:35  msmcq
# revisions in connection with di, for p3; see comments for details
# 
# Revision 1.4  1994/01/04  12:14:45  lou
# fix xrefs
#
# Revision 1.3  1993/09/22  19:27:14  msmcq
# allow multiple targets
#
# Revision 1.2  1993/09/16  16:10:53  msmcq
# Add to terminologyInclusions class
#
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 94-01-15 : MSM : add xref to di                          -->
<!-- 94-01-14 : MSM : mentioned, not cited                    -->
<!-- 94-01-14 : MSM : add to ditoplev class                   -->
<!-- 94-01-12 : MSM : targetEnd not target.end                -->
<!-- 93-09-17 : MSM : make target take IDREFS not IDREF       -->
<!-- 93-09-17 : MSM : (parallel to ptr, ref)                  -->
<!-- 93-09-15 : MSM : include in class termincl               -->
<!-- 92-12-09 : MSM : assign to class biblpart                -->
<!-- 92-12-09 : MSM : target.end only for displaced notes     -->
<!-- 92-12-07 : MSM : change model to specialPara             -->
<!-- 92-12-07 : MSM : expand tabs                             -->
<!-- 92-11-23 : MSM : correct type in ATT end-tag             -->
<!-- ******************************************************** note -->
<tagDoc id=NOTE usage=rec>
<gi>note</gi>
<desc>contains a note or annotation.
<attList>
<attDef usage=opt>
<attName>n
<name>number or symbol
<desc>indicates the symbol or number used to mark the note's point of
attachment to the main text.
<datatype>CDATA
<valDesc>any string of characters
<default>#IMPLIED
<eg><![ CDATA [
Mevorakh b. Saadya's mother, the matriarch of the family
during the second half of the eleventh century,
   <note n=126>
        The alleged mention of Judah Nagid's mother
        in a letter from 1071 is, in fact, a
        reference to Judah's children; cf. above,
        nn. 111 and 54.
   </note>
is well known from Geniza documents published by Jacob Mann.
]]>
</eg>
<remarks><p>If notes are numbered in sequence and their numbering can be
reconstructed automatically by processing software, it may not be
considered necessary to record the note numbers.
</attDef>
<attDef usage=opt>
<attName>type
<desc>describes the type of note.
<datatype>CDATA
<valDesc>Values can be taken from any convenient typology of annotation
suitable to the work in hand;  e.g. annotation, gloss, citation,
digression, preliminary, temporary, ...
<default>#IMPLIED
</attDef>
<attDef usage=rwa>
<attName>resp
<name>responsible
<desc>indicates who is responsible for the annotation:  author, editor,
translator, etc.
<datatype>CDATA
<valList type=open>
    <val>auth[or]
    <desc>note originated with the author of the text.
    <val>ed[itor]
    <desc>note added by the editor of the text.
    <val>comp[iler]
    <desc>note added by the compiler of a collection.
    <val>tr[anslator]
    <desc>note added by the translator of a text.
    <val>transcr[iber]
    <desc>note added by the transcriber of a text into electronic form.
    <val>(initials)
    <desc>note added by the individual indicated by the initials.
</valList>
<default>#IMPLIED
<remarks><p>For specialized types of editorial annotation (e.g. for
marking corrections, normalizations, cruxes, etc.), see chapter <xref
type=div1 target=TC>.
</attDef>
<attDef usage=opt>
<attName>place
<desc>indicates where the note appears in the source text.
<datatype>CDATA
<valList type=open>
    <val>foot
    <desc>note appears at foot of page.
    <val>end
    <desc>note appears at end of chapter or volume.
    <val>inline
    <desc>note appears as a marked paragraph in the
        body of the text.
    <val>left
    <desc>note appears in left margin.
    <val>right
    <desc>note appears in right margin.
    <val>interlinear
    <desc>note appears between lines of the text.
    <val>app[aratus]
    <desc>note appears in the apparatus at the foot of the
        page.
</valList>
<default>'unspecified'
<eg><![ CDATA [
]]>
</eg>
<remarks><p>For pages with multiple apparatus, values such as
<term>app1</term> and <term>app2</term> can be used.
<p>The <att>place</att> attribute can be used to indicate to text
formatting software where a note should be printed.  If the locations
indicated do not agree with those in the copy text, that fact should be
indicated in the TEI header.
</attDef>
<attDef usage=opt>
<attName>anchored
<desc>indicates whether the copy text shows the exact place of reference
for the note.
<datatype>(yes | no)
<valList type=closed>
    <val>yes
    <desc>copy text indicates the place of attachment for the note.
    <val>no
    <desc>copy text indicates no place of attachment for the note.
</valList>
<default>yes
<remarks><p>In modern texts, notes are usually anchored by means of
explicit footnote or endnote symbols.  An explicit indication of the
phrase or line annotated may however be used instead (e.g.  <q>page 218,
lines 3-4</q>).  The <att>anchored</att> attribute indicates whether any
explicit location is given, whether by symbol or by prose
cross-reference.  If the specific symbols used are to be recorded, use
the <att>n</att> attribute.
</attDef>
<attDef usage=rwa>
<attName>target
<desc>indicates the point of attachment of a note, or the beginning of
the span to which the note is attached.
<datatype>IDREFS
<valDesc>reference to the <att>id</att>s of element(s) which begin at
the location in question (e.g. the <att>id</att> of an <gi>anchor</gi>
element).
<default>#IMPLIED
<eg><![ CDATA [
]]>
</eg>
<remarks><p>If <att>target</att> and <att>targetEnd</att> are to be
used to indicate where notes attach to the text, then elements at the
appropriate locations (<gi>anchor</gi> elements if necessary) must be
given <att>id</att> values to be pointed at.
</attDef>
<attDef usage=rwa>
<attName>targetEnd
<desc>points to the end of the span to which the note is attached, if
the note is not embedded in the text at that point.
<datatype>IDREFS
<valDesc>reference to the <att>id</att>(s) of element(s) which
<emph>end</emph> at the location(s)
in question, or to an empty element at
the point in question.
<default>#IMPLIED
<eg><![ CDATA [
]]>
</eg>
<remarks><p>
</attDef>
</attList>
<exemplum><eg><![ CDATA [
And yet it is not only in the great line of Italian
renaissance art, but even in the painterly
    <note resp=Tr><term lang=DE>Malerisch</term>.  This
    word has, in the German, two distinct meanings, one
    objective, a quality residing in the object, the
    other subjective, a mode of apprehension and creation.
    To avoid confusion, they have been distinguished in
    English as <mentioned>picturesque</> and
    <mentioned>painterly</> respectively.  (Tr.)</note>
style of the Dutch genre painters of the seventeenth
century that drapery has this psychological significance.
]]>
</eg>
</exemplum>
<remarks><p>
<part type=top name=core>
<classes names="NOTES BIBLPART TERMINCL DITOPLEV">
<dataDesc>May contain character data and phrase-level elements.
<elemDecl>- O  (%specialPara;)
</elemDecl>
<xref type=div2 target=CONONO>
<xref target=HD27>
<xref target=COBICON>
<xref target=DITPNO>
<xref target=TETA>
</tagDoc>
<?tei:EOF note.tag ?>
