<?tei:SOF quotn.tag ?>
<!-- $Id: quotn.tag,v 1.2 94/01/04 12:15:06 lou Exp $ -->
<!-- $Log:	quotn.tag,v $
# Revision 1.2  94/01/04  12:15:06  lou
# fix xrefs
# 
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 93-06-01 : MSM : minor change to wording of FORM att     -->
<!-- 92-08-19 : MSM : delete empty name element               -->
<!-- 92-08-19 : MSM : fix msc problem                         -->
<!-- ***********************************************quotation -->
<tagDoc usage=opt id="QUOTN"><gi>quotation</gi>
<desc>specifies editorial practice adopted with respect to quotation
marks in the original. </desc>
<attList>
<attDef>
<attName>marks
   <desc>indicates whether or not quotation marks have been retained as
       content within the text.
   <datatype>(none | some | all)
   <valList><val>none<desc>no quotation marks have been retained
  <val>some<desc>some quotation marks have been retained
  <val>all<desc>all quotation marks have been retained
   </valList><default>all
<attDef><attName>form
   <desc>specifies how quotation marks are indicated within the text.
   <datatype>(data | rend | std | nonstd | unknown)
   <valList>
      <val>data    <desc>quotation marks are retained as data.
      <val>rend    <desc>the <att>rendition</att> attribute is
                         consistently used to indicate the form of
                         quotation marks.
      <val>std     <desc>use of quotation marks has been standardized.
      <val>nonstd  <desc>quotation marks are represented inconsistently.
      <val>unknown <desc>use of quotation marks is unknown.
   </valList><default>unknown
</attList>
<exemplum><eg><![ CDATA[
  <quotation marks=none form=rend>
    <p>No quote marks have been retained. Instead, the rendition
    attribute on the Q element is used to specify what kinds of
    quote mark was used, according to the following list:
    <list type=gloss>
      <label>dq  <item>double quotes open and close
      <label>sq  <item>single quotes open and close
      <label>dash<item>long dash open
      <label>dg  <item>double guillemets open and close
    </list>
  </quotation>
]]>
</eg></exemplum>
<exemplum><eg><![ CDATA[
  <quotation marks=all form=std>
  <p>All quotation marks are retained in the text and are
   represented by standard entity references
  </quotation>
]]>
</eg>
</exemplum>
<remarks></remarks>
<part type=aux name=hdr><classes names=DECLABL>
<dataDesc></dataDesc>
<elemDecl>- o (p+)</elemDecl>
<xref target='HD53'>
<xref target=CCAS2>
</tagDoc>
<?tei:EOF quotn.tag ?>
