<?tei:SOF rate.tag ?>
<!-- ************************************************************ -->
<!-- TAGDOC for RATE                                              -->
<!-- $Id: rate.tag,v 1.3 94/04/08 01:52:06 msmcq Exp $ -->
<!-- $Log:	rate.tag,v $
# Revision 1.3  94/04/08  01:52:06  msmcq
# Last fixes for FD in P3, etc.
# 
# Revision 1.2  1994/01/04  01:17:21  msmcq
# revise DESC on values
# of REL
#
# Revision 1.1  1993/09/23  02:36:34  msmcq
# Unpacked TDL changes July 93
# -->
<!-- Revisions:                                               -->
<!-- 94-04-07 : MSM : add to class singval                    -->
<!-- 93-12-23 : MSM : change value, valueTo atts:  CDATA not NUMBER -->
<!-- 93-12-22 : MSM : change descriptions on REL att values   -->
<!-- 93-09-22 : MSM : extract from bulk file                  -->
<!-- ************************************************************ -->
<tagDoc id=RATE usage=rwa>
<gi>rate</gi>
<name>rate value
<desc>provides a rate value or range of values for a feature.
<attList>
<attDef id=RATEVAL usage=req>
<attName>value
<desc>provides a numeric value.
<datatype>CDATA
<valDesc>A real number or integer.
<default>#REQUIRED
</attDef>
<attDef id=RTVALTO usage=opt>
<attName>valueTo
<desc>together with <att>value</att> attribute, provides a numeric range
of values.
<datatype>CDATA
<valDesc>A real number or integer.
<default>#IMPLIED
</attDef>
<attDef id=RTUNIT usage=rwa>
<attName>unit
<desc>provides a unit for a rate feature, one of a finite list that
may be specified in a feature declaration.
<datatype>CDATA
<valDesc>A string, e.g. <term>meter</term>.
<default>#IMPLIED
</attDef>
<attDef id=RATEPER usage=req>
<attName>per
<desc>provides an interval for a rate feature, one of a finite list that
may be specified in a feature declaration.
<datatype>CDATA
<valDesc>A string, e.g. <term>second</term>.
<default>#REQUIRED
</attDef>
<attDef id=RATEREL usage=req>
<attName>rel
<desc>indicates the relation of the given value or range to the actual
value or range.
<datatype>(eq|ne|gt|ge|lt|le)
<valList type=closed>
   <val>eq     <desc>indicates that the actual value or range is that
given.
   <val>ne     <desc>indicates that the actual value or range is not the
value or range given by the element.
   <val>lt     <desc>indicates that the actual value or range is less
than the given value or range.
   <val>le     <desc>indicates that the actual value or range is less
than or equal to the given value or range.
   <val>gt     <desc>indicates that the actual value or range is greater
than the given value or range.
   <val>ge     <desc>indicates that the actual value or range is greater
than or equal to the given value or range.
</valList>
<default>eq
</attDef>
<attDef id=RATETYPE usage=opt>
<attName>type
<desc>indicates whether value is to be understood as real or integer.
<datatype>(int|real)
<valList type=closed>
   <val>int    <desc>specifies that value is an integer; if noninteger
is given as value of <att>value</att>, then only integer part is used.
   <val>real   <desc>specifies that value is that of a real number.
</valList>
<default>#IMPLIED
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
<rate rel=gt value=65 unit=mile per=hour>
]]>
</eg>
</exemplum>
<part type=top name=fs>
<classes names="SINGVAL">
<dataDesc>Empty tag.
<elemDecl>- O EMPTY</elemDecl>
<xref type=div3 target=FSSY>
</tagDoc>
<?tei:EOF rate.tag ?>
