<?tei:SOF reldate.tag ?>
<!-- $Id: reldate.tag,v 1.2 93/08/03 02:09:53 msmcq Exp $ -->
<!-- $Log:	reldate.tag,v $
# Revision 1.2  93/08/03  02:09:53  msmcq
# fix MS end, fix or flag valdesc problems
#  -->
<!-- Revisions:                                               -->
<!-- 93-08-02 : MSM : Added RCS id                            -->
<!-- 93-06-04 : MSM : Flagged empty valdescs                  -->
<!-- 93-06-03 : MSM : Fixed ]]> problem                       -->
<!--******************************************************** reldate -->
<tagDoc usage=opt id="RELDATE"><gi>reldate</gi>
<name>relative date</name>
<desc>a specific instance of a relative date
where a date is indicated by referring to some
fixed reference point (e.g. <q>A fortnight after Michaelmas</q>
or <q>In the year of our Lord One Thousand Nine Hundred and
Seventy Seven and Two Hundred and One of the Republic</q>.
</desc>
<attList>
<attDef usage=mwa><attName>type</attName>
<desc>provides further information about the kind of relative
date that is involved in the expression. Possible values
include <q>precise</q> as in <q>A fortnight after Michaelmas, 1992</q>,
and <q>imprecise</q> as in <q>a few days before Christmas in the
winter of '84</q>. </desc>
<datatype>CDATA
<valDesc>[Error:  value description needed]</valDesc>
<default>#IMPLIED
<attDef usage=opt><attName>value</attName>
<desc>supplies the value of the date in an application-dependent
standard form such as <q>mm-dd-yyyy</q> or <q>dd-mm-yyyy</q>.
<datatype>CDATA
<valDesc>any date value in the chosen standard form.
<default>#IMPLIED
<remarks><p>The standard form used should be described in the
<gi>std.vals</gi> element in the TEI header.  Standard forms may be
defined from scratch, or borrowed from existing practice.
</attDef>
<attDef usage=opt>
<attName>key
<desc>provides an alternative identifier for the date,
such as a database record key.
<datatype>CDATA
<valDesc>any string
<default>#IMPLIED
<remarks><p>The value may be a unique identifier from a database, or
simply a more explicit name for the referent. Its purpose is only to
record an identification; if the analysis leading to the identification
is to be recorded as well, the analytic tags described in chapter <xref
target=FS> should be used in addition or instead.
</attDef>
</attList>
<exemplum><eg><![ CDATA [
<reldate value='1977'><offSet reg='after'>in the
<distance type=measured reg='201 years'>Two Hundredth and
First Year</distance> of the
<date calendar='event' value='1776'><event type=foundation>Republic</event>
</date></reldate>.
 
<reldate value='11-12-86'>A <distance reg='14 days'>fortnight</distance
<offSet reg='before'>before</offSet>
<date value='25-12-86'><event type=holiday>Christmas</event></date>
</reldate>
]]>
</eg></exemplum>
<remarks></remarks>
<part type=top name=office><classes>
<elemDecl>- - (%phrase.seq)</elemDecl>
<xref target=NDDATE>
</tagDoc>
<?tei:EOF reldate.tag ?>
