<?tei:SOF reltime.tag ?>
<!-- $Id: reltime.tag,v 1.1 93/06/23 11:28:40 lou Exp $ -->
<!-- $Log:	reltime.tag,v $
# Revision 1.1  93/06/23  11:28:40  lou
# Initial checkin
#  -->
<!--******************************************************** reltime-->
<tagDoc usage=opt id="RELTIME"><gi>reltime</gi>
<name>relative time</name>
<desc>a specific instance of a temporal expression 
where a time is indicated by referring to some 
fixed reference point e.g. <q>Twenty minutes before the game</q>.</desc>
<attList>
<attDef usage=mwa><attName>type</attName>
<desc>provides further information about the kind of relative
temporal expression that is involved. Possible values
include <q>precise</q> as in <q>Twenty minutes before noon</q>,
and <q>imprecise</q> as in <q>a few hours before dinner</q>. </desc>
<datatype>CDATA
<valDesc></valDesc>
<default>#IMPLIED
<attDef usage=opt><attName>value</attName>
<desc>supplies the value of the time in an application-dependent
standard form such as <q>hour:minute.second</q>.
<datatype>CDATA
<valDesc>any time value represented in the chosen standard form.
<default>#IMPLIED
<remarks><p>The standard form used should be described in the
<gi>std.vals</gi> element in the TEI header.  Standard forms may be
defined from scratch, or borrowed from existing practice.
</attDef>
<attDef usage=opt>
<attName>key
<desc>provides an alternative identifier for the time,
such as a database record key.
<datatype>CDATA
<valDesc>any string
<default>#IMPLIED
<remarks><p>The value may be a unique identifier from a database, or
simply a more explicit name for the referent. Its purpose is only to
record an identification; if the analysis leading to the identification
is to be recorded as well, the analytic tags described in chapter <xref
target=FS> should be used in addition or instead.
</attDef>
</attList>
<exemplum><eg><![ CDATA [
I got to the station <reltime value='14:15'>
<distance type=imprecise value='30 minutes'>about a half hour</distance>
<offSet>after</offSet> <event value='13:45'>the train to Boston 
left</event></reltime>
In practice, festival candles are lit <reltime><distance
type=imprecise>just</distance> <offSet>before</offSet> <event
reg='evening'>sundown</event></reltime>
]]></eg></exemplum>
<remarks></remarks>
<part type=top name=office><classes>
<elemDecl>- - (%phrase.seq)</elemDecl>
<xref target=NDDATE>
</tagDoc>
<?tei:EOF reltime.tag ?>
