<?tei:SOF respons.tag ?>
<!-- $Id: respons.tag,v 1.3 94/03/15 11:10:40 lou Exp $ -->
<!-- $Log:	respons.tag,v $
# Revision 1.3  94/03/15  11:10:40  lou
# minor typos etc
# 
# Revision 1.1  1993/08/03  02:27:04  msmcq
# tagdoc files:  resynching uicvm and onions
# -->
<!-- *************************************************** resp -->
<!--12 mar:  change class membership from global to metadata -->
<tagDoc id=RESPONS usage=opt>
<gi>respons</gi>
<name>responsibility
<desc>identifies the individual(s) responsible for some aspect of the
markup of some particular element(s).
<attList>
<!-- ................................................. target -->
<attDef usage=req>
<attName>target
<desc>gives the SGML identifier(s) of the element(s) for which some
aspect of the responsibility is being assigned.
<datatype>IDREFS
<valDesc>one or more SGML identifiers.
<default>#REQUIRED
<remarks><p></remarks>
</attDef>
<!-- .................................................. locus -->
<attDef usage=req>
<attName>locus
<desc>indicates the specific aspect of the markup for which
responsibility is being assigned.
<datatype>CDATA
<valList type=semi>
<val>#gi <desc>responsibility for the claim that the element is of the
type indicated by the markup
<val>#location <desc>responsibility for the claim that the element
begins and ends where indicated
<val>#startloc <desc>responsibility for the claim that the element
begins where indicated
<val>#endloc <desc>responsibility for the claim that the element
ends where indicated
<val>name<desc>responsibility for the claim that the
<att>name</att> attribute has the value given in the markup
<val>#transcribedContent <desc>responsibility for the transcription of
the element content
<val>#suppliedContent <desc>responsibility for the contents supplied by
the encoder (corrections, expansions of abbreviations, etc.)
</valList>
<default>#REQUIRED
<remarks><p></remarks>
</attDef>
<!-- ................................................... resp -->
<attDef usage=req>
<attName>resp
<desc>identifies the individual or agency responsible for the indicated
aspect of the electronic text.
<datatype>CDATA
<valDesc>any string of characters, typically the initials of an
individual, the acronym of an agency, the name of a computer program,
etc.
<default>#REQUIRED
<remarks><p></remarks>
</attDef>
<!-- ................................................... desc -->
<attDef usage=opt>
<attName>desc
<name>description
<desc>gives a brief prose note supplying any additional information
which should be recorded
<datatype>CDATA
<valDesc>any string of characters, typically a phrase or sentence in a
natural language.
<default>#IMPLIED
<remarks><p></remarks>
</attDef>
</attList>
<exemplum><eg><![ CDATA [
 <respons target=P1 
          locus='#gi #location' resp=AR>
  <respons target=P2
          locus=rend resp=LB>
]]>
</eg></exemplum>
<remarks><p>The <gi>respons</gi> element is designed for cases in which
fine-grained information about specific aspects of the markup of a text
is desirable for whatever reason.  Global responsibility for certain
aspects of markup is usually more simply indicated in the TEI header,
using the <gi>respStmt</gi> element within the title statement, edition
statement, or change log.
</remarks>
<part type=top name=cert>
<classes names="METADATA">
<dataDesc>Empty.
<elemDecl>- O EMPTY
</elemDecl>
<xref target=CERESP>
</tagDoc>


<?tei:EOF respons.tag ?>
