<?tei:SOF shift.tag ?>
<!-- $Id: shift.tag,v 1.4 94/04/01 17:41:18 msmcq Exp $ -->
<!-- $Log:	shift.tag,v $
# Revision 1.4  94/04/01  17:41:18  msmcq
# Changes while checking DTD
# 
# Revision 1.3  1994/01/04  12:15:20  lou
# fix xrefs
#
# Revision 1.2  1993/09/21  11:07:59  lou
# added to spoken class
#
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 94-03-29 : MSM : member of compspok, not spoken          -->
<!-- 93-02-10 : MSM : change target of xref                   -->
<!-- ************************************************** shift -->
<tagDoc usage=opt id="SHIFT"><gi>shift</gi>
<name>Shift</name>
<desc>marks the point at which some paralinguistic feature of a series of
utterances by any one speaker changes.</desc>
<attList>
<attDef><attName>who</attName>
    <desc>supplies an identifier for the speaker or group of speakers
         whose shift in some feature is being noted.
         Its value is the identifier of a <tag>participant</tag>
         or <tag>participant.grp</tag> element in the TEI header.</desc>
    <datatype>IDREF</datatype>
    <valDesc>Must identify a participant or participant group within the
       TEI Header</valDesc>
    <default>#IMPLIED</default>
</attDef>
<attDef><attName>feature</attName>
    <name>feature</name>
    <desc>a paralinguistic feature.</desc>
    <datatype>(tempo | loud | pitch | tension | rhythm | voice)
    </datatype>
    <valList>
    <val>tempo   <desc>speed of utterance.
    <val>loud    <desc>loudness.
    <val>pitch   <desc>pitch range.
    <val>tension <desc>tension or stress pattern.
    <val>rhythm  <desc>rhythmic qualities.
    <val>voice   <desc>voice quality.
    </valList>
    <default>#REQUIRED</default>
    <remarks></remarks>
</attDef>
<attDef><attName>new</attName>
    <name>new state</name>
<desc>specifies the new state of the paralinguistic feature specified.
</desc>
    <datatype>CDATA</datatype>
    <valDesc>An open list (for an example of possible values, see
      <xref target=TSSAPA>)</valDesc>
    <default>normal</default>
    <remarks><p>If no value is specified, it is assumed that the feature
concerned ceases to be remarkable. The value <q>normal</q> has the same
effect.
   </remarks>
</attDef>
</attList>
<exemplum><eg><![ CDATA[
    <u who=LB><shift feature=loud new=f>Elizabeth
    <u who=EB>Yes
    <u who=LB><shift>Come and try this <pause>
         <shift feature=loud new=ff>come on
]]>
</eg>
<p>The word <q>Elizabeth</q> is spoken loudly, the words <q>Yes</q> and
<q>Come and try this</q> with normal volume, and the words <q>come on</q>
very loudly.
</exemplum>
<remarks></remarks>
<part type=base name=ts>
<classes names=COMPSPOK>
<dataDesc>empty</dataDesc>
<elemDecl>- O EMPTY</elemDecl>
<xref target="TSBAFD">
<xref target="TSSASH">
<xref target="TSBA">
</tagDoc>
<?tei:EOF shift.tag ?>
