<?tei:SOF sic.tag ?>
<!-- $Id: sic.tag,v 1.4 1998/02/09 14:30:22 tei Exp $ -->
<!--*
    * $Log: sic.tag,v $
    * Revision 1.4  1998/02/09 14:30:22  tei
    * fixing egs....
    *
    * Revision 1.3  94/03/28  19:59:41  msmcq
    * punctuations, tyops (i don't know)
    * 
    * Revision 1.2  1993/08/03  02:22:09  msmcq
    * fix INHERITED keyword
    * -->
 
<!-- Revisions:                                               -->
<!-- 93-08-02 : MSM : Added RCS id                            -->
<!-- 93-06-21 : MSM : correct INHERITED                       -->
<!-- 92-12-07 : MSM : change model to specialPara             -->
<!-- 92-11-09 : MSM : supply missing end-tag for gi           -->
<!-- 92-11-09 : MSM : change id ref                           -->
<!-- ********************************************************* sic --
>
<tagDoc id=SIC usage=opt>
<gi>sic</gi>
<desc>contains text reproduced although apparently incorrect or
inaccurate.
<attList>
<attDef usage=opt>
<attName>corr
<name>correction
<desc>gives a correction for the apparent error in the copy text.
<datatype>CDATA
<valDesc>any string of characters
<default>#IMPLIED
<eg><![ CDATA [
  for his nose was as sharp as a pen, and
  <sic corr="a' babbled">a Table</sic>
  of green fields.
]]>
</eg>
</attDef>
<attDef usage=opt>
<attName>resp
<name>responsibility
<desc>signifies the editor or transcriber responsible for suggesting
the correction held as the value of the <att>corr</att> attribute.
<datatype>IDREF
<valDesc>must be one of the identifiers declared in the document
header, associated with a person asserted as responsible for some
aspect of the text's creation, transcription, editing or encoding
(see chapter <xref target=CE>).
<default>%INHERITED
<eg><![ CDATA [
  for his nose was as sharp as a pen, and
  <sic resp="Gifford" corr="a' babbled">a Table</sic>
  of green fields.
]]>
</eg>
<remarks><p>This attribute has no meaning if no <att>corr</att>
attribute is supplied.
</attDef>
<!-- ................................................... cert -->
<attDef usage=opt>
<attName>cert
<name>certainty
<desc>signifies the degree of certainty ascribed to the correction
held as the value of the <att>corr</att> attribute.
<datatype>CDATA
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>This attribute has no meaning if no <att>corr</att>
attribute is supplied.
</attDef>
</attList>
<exemplum><p>If all that is desired is to call attention to the
apparent problem in the copy text, no attributes are required:</p>
<eg><![ CDATA [
I don't know, Juan.  It's so far in the past now &mdash;
how <sic>we can</sic> prove or disprove anyone's theories?
]]>
</eg>
<p>It is also possible to provide a correct reading and to identify
the individual responsible for the correction:
<eg><![ CDATA [
I don't know, Juan.  It's so far in the past now &mdash;
how <sic corr='can we' resp='MSM'>we can</sic> prove or
disprove anyone's theories?
]]>
</eg></exemplum>
<remarks><p>The <gi>sic</gi> tag is a mirror of <gi>corr</gi>:	the
former leaves the original text untouched, giving the correction as
an
attribute value; the latter substitutes the correction, leaving the
original reading as an attribute value.  The choice between them is
up
to the encoder.
<part type=top name=core>
<classes names=EDIT>
<dataDesc>May contain character data and phrase-level elements.
<elemDecl>- -  (%specialPara;)
</elemDecl>
<xref type=div3 target=COEDCOR>
</tagDoc>
 
<?tei:EOF sic.tag ?>
