<?tei:SOF space.tag ?>
<!-- Revisions:                                               -->
<!-- 3 Jan 97 : LB : fixed incidate typo -->
<!-- 94-08-04 : MSM : fix REACH:  make member of EDIT         -->
<!-- 94-04-07 : MSM : full stop after desc                    -->
<!-- $Id: space.tag,v 1.6 98/01/28 19:22:39 tei Exp $ -->
<!--*
    * $Log:	space.tag,v $
# Revision 1.6  98/01/28  19:22:39  tei
# LB changes of 1998-01
# 
    * Revision 1.5  1994/08/29  15:23:27  msmcq
    * Changes for unreachability bugs
    * 
    * Revision 1.4  1994/04/08  01:52:06  msmcq
    * Last fixes for FD in P3, etc.
    * 
    * Revision 1.3  1994/03/28  15:11:20  lou
    * rename SIZE as EXTENT to match examples
    * 
    * Revision 1.2  1994/03/15  11:10:44  lou
    * minor typos etc
    * 
    * Revision 1.1  1993/08/03  02:27:04  msmcq
    * tagdoc files:  resynching uicvm and onions
    *-->
<!-- 14 mar: fix xrefs; remove egregious comments and empty examples
-->
<!-- ************************************************** space -->
<tagDoc id="SPACE" usage="opt">
<gi>space</gi>
<desc>indicates the location of a significant space in the copy text.</desc>
<attList>
<!-- .................................................... dim -->
<attDef usage="rec">
<attName>dim</attName>
<name>dimension</name>
<desc>indicates whether the space is horizontal or vertical.</desc>
<datatype>(horizontal | vertical)</datatype>
<valList type="closed">
<val>horizontal</val> <desc>the space is horizontal.</desc>
<val>vertical</val> <desc>the space is vertical.</desc>
</valList>
<default>#IMPLIED</default>
<remarks><p>For irregular shapes in two dimensions, the value for
this attribute should reflect the more important of the two dimensions.
In conventional left-right scripts, a space with both vertical and
horizontal components should be classed as <q>vertical</q>.</p></remarks>
</attDef>
<!-- ................................................... size -->
<attDef usage="opt">
<attName>extent</attName>
<desc>indicates approximately how large the space is, in letters,
minims, inches, or other appropriate unit.</desc>
<datatype>CDATA</datatype>
<valDesc>any measured quantity, e.g. <q>10 letters</q> or <q>4
lines</q>.</valDesc>
<default>#IMPLIED</default>
<remarks><p>
<!-- renamed from length to extent, so as to match examples (why not?) -->
<!-- [Renamed <att>length</att> as <att>size</att>. -MSM] --></p></remarks>
</attDef>
<!-- ................................................... resp -->
<attDef usage="opt">
<attName>resp</attName>
<desc>indicates the individual responsible for identifying and measuring
the space.</desc>
<datatype>CDATA</datatype>
<valDesc>usually the initials of the responsible individual.</valDesc>
<default>#IMPLIED</default>
<remarks><p>
<!-- [Not clear why this attribute is needed; could perhaps -->
<!-- better be handled by a general tagging-responsibility mechanism-->
<!-- parallel to the certainty mechanism of chapter CE. -MSM] --></p></remarks>
</attDef>
</attList>
<exemplum><eg><![ CDATA [
<![ CDATA [
By god if wommen had writen storyes
As <space extent='7'> han within her oratoryes
]]>
</eg></exemplum>
<remarks><p>This element should be used wherever it is desired to record
an unusual space in the source text, e.g. space left for a word to be
filled in later, for later rubrication, etc.  It is not intended to be
used to mark normal inter-word space or the like.</p></remarks>
<part type="top" name="PH">
<classes names="EDIT">
<dataDesc>Empty.</dataDesc>
<elemDecl>- O  EMPTY
</elemDecl>
<xref target="PHSP">
</tagDoc>
<?tei:EOF space.tag ?>
