<?tei:SOF state.tag ?>
<!-- $Id: state.tag,v 1.2 94/01/04 12:15:25 lou Exp $ -->
<!-- $Log:	state.tag,v $
# Revision 1.2  94/01/04  12:15:25  lou
# fix xrefs
# 
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 92-08-19 : MSM : provide valdesc for length att          -->
<!-- ********************************************************state -->
<tagDoc usage=opt id="STATE"><gi>state</gi>
<desc>specifies one component of a canonical reference defined by
the <q>milestone</q> method.</desc>
<attList>
<attDef id=ED usage=opt>
<attName>ed
<name>edition
<desc>indicates which edition or version the milestone applies to.
<datatype>CDATA
<valDesc>Any string of characters; usually a siglum conventionally used
for the edition.
<default>#IMPLIED
<remarks><p>If <att>ed</att> is not specified, then any milestone
tag with an appropriate <att>unit</att> attribute will be selected.
</attDef>
<attDef id=UNIT usage=req>
<attName>unit
<desc>indicates what kind of section is changing at this milestone.
<datatype>CDATA
<valList type=semi>
    <val>page   <desc>page breaks in the reference edition.
    <val>column <desc>column breaks.
    <val>line   <desc>line breaks.
    <val>book   <desc>any units termed <q>book</q>,<q>liber</q>, etc.
    <val>poem   <desc>individual poems in a collection.
    <val>canto  <desc>cantos or other major sections of a poem.
    <val>stanza <desc>stanzas within a poem, book, or canto.
    <val>act    <desc>acts within a play.
    <val>scene  <desc>scenes within a play or act.
    <val>section<desc>sections of any kind.
    <val>absent <desc>passages not present in the reference edition.
</valList>
<default>#REQUIRED
<remarks></remarks>
</attDef>
<attDef><attName>length</attName>
    <desc>specifies the fixed length of the reference component.</desc>
    <datatype>NUMBER</datatype>
    <valDesc>Should be a positive integer; if no value is provided,
    the length is unlimited and goes to the next delimiter or to the
    end of the value.</valDesc>
    <default>#IMPLIED</default>
    <remarks><p>When constructing a reference, if the reference component
  found is of numeric type, the length
  is made up by inserting leading zeros; if it is not, by inserting
  trailing blanks. In either case, reference components are truncated
  if necessary at the right hand side.
  <p>When seeking a reference, the length indicates the
  number of characters which should be compared. Values longer than
  this will be regarded as matching, if they start correctly. </remarks>
    </attDef>
<attDef><attName>delim</attName>
    <desc>supplies a delimiting string following the reference
          component.</desc>
    <datatype>CDATA</datatype>
    <valDesc>If a single space is used it is interpreted as
          whitespace.</valDesc>
    <default>#IMPLIED</default>
    <remarks></remarks>
    </attDef>
</attList>
<exemplum><eg><![ CDATA[
  <state unit=book delim=":">
  <state unit=line length=4>
]]>
</eg></exemplum>
<remarks></remarks>
<part type=aux name=hdr><classes>
<dataDesc></dataDesc>
<elemDecl>- o EMPTY</elemDecl>
<xref target='HD54M'>
<xref target='HD54'>
</tagDoc>
<?tei:EOF state.tag ?>
