<?tei:SOF step.tag ?>
<!-- $Id: step.tag,v 1.3 94/03/25 16:02:11 msmcq Exp $ -->
<!-- $Log:	step.tag,v $
# Revision 1.3  94/03/25  16:02:11  msmcq
# make changes as per J. Lavagnino
# implementing new extended-pointer mechanism for canonical refs.
# 
# Revision 1.2  1994/01/04  12:15:26  lou
# fix xrefs
#
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 94-03-24 : MSM : del gi, att attributes                  -->
<!-- 94-03-24 : MSM : add refunit, from, to                   -->
<!-- 92-08-19 : MSM : provide valdesc for length att          -->
<!-- *********************************************************step -->
<tagDoc usage=opt id="STEP"><gi>step</gi>
<name>step</name>
<desc>specifies one component of a canonical reference defined by
the <q>stepwise</q> method.</desc>
<attList>
<!-- ................................................ refunit -->
<attDef usage=rec>
<attName>refunit
<name>reference unit
<desc>names the unit (book, chapter, canto, verse, ...) identified
by this step in a canonical reference.
<datatype>CDATA
<valDesc>any string of characters; typically a word or phrase in
some natural language.
<default>#IMPLIED
<remarks><p>The provision of this attribute helps make the structure
of the canonical reference much clearer.
<!-- and may make it possible for application software to     -->
<!-- handle canonical references much more intelligently.     -->
Its use is strongly recommended.
</attDef>
<attDef><attName>length</attName>
    <desc>specifies the fixed length of the reference component.</desc>
    <datatype>NUMBER</datatype>
    <valDesc>Should be a positive integer; if no value is provided,
    the length is unlimited and goes to the next delimiter or to the
    end of the value.</valDesc>
    <default>#IMPLIED</default>
    <remarks><p>When constructing a reference, if the reference component
  found is of numeric type, the length
  is made up by inserting leading zeros; if it is not, by inserting
  trailing blanks. In either case, reference components are truncated
  if necessary at the right hand side.
  <p>When seeking a reference, the length indicates the
  number of characters which should be compared. Values longer than
  this will be regarded as matching, if they start correctly. </remarks>
    </attDef>
<attDef><attName>delim</attName>
    <desc>supplies a delimiting string following the reference
          component.</desc>
    <datatype>CDATA</datatype>
    <valDesc>If a single space is used it is interpreted as
         whitespace</valDesc>
    <default>#IMPLIED</default>
    <remarks></remarks>
    </attDef>
<!-- ................................................... from -->
<attDef usage=req>
<attName>from
<desc>specifies the starting point of the area referred to by this
step in the canonical reference.
<datatype>%extPtr
<valDesc>a valid expression in the TEI extended pointer notation
documented in section <xref target=SAXR>.
<default>#REQUIRED
</attDef>
<!-- ..................................................... to -->
<attDef usage=req>
<attName>to
<desc>specifies the ending point of the area referred to by this step
in the canonical reference.
<datatype>%extPtr
<valDesc>a valid expression in the TEI extended pointer notation
documented in section <xref target=SAXR>.
<default>'DITTO'
<remarks><p> (optional)
</attDef>
</attList>
<exemplum><eg><![ CDATA[
  <step delim=":" from='CHILD (1 DIV1 N %1)' refunit='book'>
]]>
</eg></exemplum>
<remarks><p>With two differences, the extended pointer expressions given
as values for the <att>from</att> and <att>to</att> attributes behave
like those given for the corresponding attributes of an extended pointer
element like <gi>xptr</gi>.  First:  unlike normal extended pointer
expressions, those on a <gi>step</gi> element can contain references to
tokens in the canonical reference string itself, expressed as
<code>%1</code>, <code>%2</code>, etc.  Second:  the initial location
source for the first step is the root of the document, as for normal
extended pointers.  The initial location source for subsequent steps,
however, is the result of the previous step, not the root.
<part type=aux name=hdr><classes>
<dataDesc></dataDesc>
<elemDecl>- o EMPTY</elemDecl>
<xref target='HD54M'>
<xref target='HD54'>
<xref target='HD54S'>
</tagDoc>
<?tei:EOF step.tag ?>
