<?tei:SOF teihead.tag ?>
<!-- $Id: teihead.tag,v 1.3 94/01/04 12:15:34 lou Exp $ -->
<!-- $Log:	teihead.tag,v $
# Revision 1.3  94/01/04  12:15:34  lou
# fix xrefs
# 
# Revision 1.2  1993/08/03  02:20:58  msmcq
# rename old citn as bibl
# -->
<!-- Revisions:                                               -->
<!-- 93-08-02 : MSM : Added RCS id                            -->
<!-- 93-06-21 : MSM : add explicit end tag to example         -->
<!-- 93-06-21 : MSM : change citn to bibl, etc.               -->
<!-- 93-06-01 : MSM : allow repeating encodingDesc elems      -->
<!-- 93-06-01 : MSM : also  repeating profileDesc (declable)  -->
<!-- 93-06-01 : MSM : normalized TeiHeader as teiHeader       -->
<!-- ****************************************************teiHeader -->
<tagDoc id=TEIHEAD usage=req>
<gi>teiHeader</gi>
<name>TEI Header</name>
<desc>supplies the descriptive and declarative information making up an
<q>electronic title page</q> prefixed to every
TEI-conformant text.</desc>
<attList>
<attDef>
  <attName>type
  <desc>specifies the kind of document to which the header is attached.
  <datatype>CDATA
  <valList type=closed>
    <val>text   <desc>the header is attached to a single text.
    <val>corpus <desc>the header is attached to a corpus.
  </valList>
  <default>text
</attDef>
<attDef>
  <attName>creator
  <desc>identifies the creator of the TEI Header.
  <datatype>CDATA
  <valDesc>The name or initials of the person or institution
     responsible for creating this TEI header.</valDesc>
  <default>#IMPLIED
</attDef>
<attDef>
  <attName>status
  <desc>indicates whether the header is new or has been substantially
        revised.
  <datatype>(new | update)
  <valList>
         <val>new    <desc>the header is a new header.
         <val>update <desc>the header is an update (has been revised).
  </valList>
  <default>new
</attDef>
<attDef>
  <attName>date.created
  <desc>indicates when the first version of the header was created.
  <datatype>CDATA
  <valDesc>A date in any recognizable form.
  <default>#IMPLIED
</attDef>
<attDef>
  <attName>date.updated
  <desc>indicates when the current version of the header was created.
  <datatype>CDATA
  <valDesc>A date in any recognizable form.
  <default>#IMPLIED
</attDef>
</attList>
<exemplum>
<eg><![ CDATA[
<teiHeader>
<fileDesc>
   <titleStmt>
      <title>Shakespeare: the first folio (1623) in electronic form
      <author>Shakespeare, William (1564-1616)
      <resp><role>Originally prepared by</>
      <date>1968
            <name>Trevor Howard-Hill</>
      <resp><role>Revised and edited by</>
            <name>Christine Avern-Carr</>
   <publicationStmt>
      <distributor>Oxford Text Archive
      <address>13 Banbury Road, Oxford OX2 6NN, UK
      <idno>OTA number 119
      <availability>Freely available on a non-commercial basis.
      <date>1968
   <sourceDesc>
      <bibl>The first folio of Shakespeare, prepared by Charlton Hinman
      (The Norton Facsimile, 1968)</bibl>
</fileDesc>
<encodingDesc>
   <projectDesc>
   <p>Originally prepared for use in the production of a series of
      old-spelling concordances in 1968, this text was extensively
      checked and revised for use during the editing of the new Oxford
      Shakespeare (Wells and Taylor, 1989).
   <correction>
   <p>Turned letters are silently corrected.
   <normalization>
   <p>Original spelling and typography is retained, except that long s
      and ligatured forms are not encoded.
   </editorialDecl>
   <refsDecl id=ASLREF>
      <step gi=div1 attr=n><delim string=" ">
      <step gi=div2 attr=n><delim string=".">
      <step gi=l attr=n>
   </refsDecl>
</encodingDesc>
<revisionDesc>
    <change><by>CAC<date>12 Apr 89<what>Last checked</change>
    <change><by>LB<date>1 Mar 89<what>Made new file</change>
</revisionDesc>
</teiHeader>
]]>
</eg>
</exemplum>
<remarks><p>One of the few elements unconditionally required in any
TEI document; the header may also be exchanged as an independent
document.
</remarks>
<part type=aux name=hdr>
<classes>
<dataDesc></dataDesc>
<elemDecl>- - (fileDesc, encodingDesc*, profileDesc*, revisionDesc?)
</elemDecl>
<xref target='HD11'>
<xref target=CCDEF>
</tagDoc>
<?tei:EOF teihead.tag ?>
