<?tei:SOF timeline.tag ?>
<!-- $Id: timeline.tag,v 1.2 94/08/29 15:25:03 msmcq Exp $ -->
<!-- $Log:	timeline.tag,v $
# Revision 1.2  94/08/29  15:25:03  msmcq
# Changes for unreachability bugs
#  -->
<!-- *********************************************** timeline -->
<!-- Revisions:                                               -->
<!-- 94-08-04 : MSM : fix LINKINFO, make member of METADATA   -->
<!-- 94-08-04 : MSM : Added RCS id                            -->
<!-- 93-07-22 : DTL : based on P2 definition of ALIGN         -->
<!--                  delete type= (time only, space can wait!) -->
<!--                  make origin= required                   -->
<!--                                                          -->
<tagDoc id=TIMELINE usage=opt>
<gi>timeline</gi>
<name>timeline
<desc>provides a set of ordered points in time which can be linked to
elements of a spoken text to create a temporal alignment of that text.
<attList>
<attDef usage=req>
<attName>origin
<desc>designates the origin of the timeline, i.e. the time at which it
begins.
<datatype>IDREF
<valDesc>must point to one of the <tag>when</tag> tags in its content.
<default>#REQUIRED
<remarks><p>If the time of the origin is not known, it should be
given an absolute value in descriptive terms, e.g. <q>sometime on the
night of the murder</q> or <q>unknown</q>.
</attDef>
<attDef usage=rwa>
<attName>unit
<desc>specifies the unit of time corresponding to the <att>interval</att>
value of the timeline or of its constituent points in time.
<datatype>NMTOKEN
<valDesc>a semi-closed list of recognized time units such as
<q>millisecond</q>, <q>second</q>, <q>minute</q>.
<default>#IMPLIED
</attDef>
<attDef usage=opt>
<attName>interval
<desc>specifies the numeric portion of a time interval
<datatype>NUTOKEN
<valDesc>-1 or any nonnegative number
<default>#IMPLIED
<remarks><p>The value -1 indicates uncertainty about all the intervals in
the timeline; 0 indicates that all the intervals are evenly spaced, but
the size of the intervals is not known; positive values indicate evenly
spaced values of the size specified.  If individual points in time in the
timeline are given different values for the <att>interval</att>
attribute, those values locally override the value given in the timeline.
</attList>
<exemplum><eg><![ CDATA [
<timeline id=TL1 origin=w0 unit=centisecond>
  <when id=W0 absolute='sometime Monday morning before Christmas'
  <when id=W1 since=w0 interval=-1>
  <when id=W2 since=w1 interval=10>
  <when id=W3 since=w2 interval=20>
  <when id=W4 since=w3 interval=15>
  <when id=W5 since=w4 interval=25>
  <when id=W6 since=w5 interval=10>
  </timeline>
]]>
</eg></exemplum>
<remarks><p>Occurs where??
<part type=top name=link>
<classes names="METADATA">
<dataDesc>one or more points in time, one of which is its origin
<elemDecl>- - ((when)+)</elemDecl>
<xref type=div3 target=SASYMP>
</tagDoc>
<?tei:EOF timeline.tag ?>
