<?tei:SOF title.tag ?>
<!-- $Id: title.tag,v 1.3 94/01/04 12:15:40 lou Exp $ -->
<!-- $Log:	title.tag,v $
# Revision 1.3  94/01/04  12:15:40  lou
# fix xrefs
# 
# Revision 1.2  1993/08/23  16:47:30  msmcq
# add to class hqphrase
#
# Revision 1.1  1993/06/23  11:28:40  lou
# Initial checkin
# -->
<!-- Revisions:                                               -->
<!-- 93-08-19 : MSM : add to hqphrase                         -->
<!-- 93-03-10 : MSM : change model from soup to paracontent   -->
<!-- 92-12-06 : MSM : add level, type attributes              -->
<!-- 92-11-09 : MSM : set xref to CObi                        -->
<!-- 92-08-19 : MSM : change xref to HD/22                    -->
 
<!-- ******************************************************* title -->
<tagDoc usage=opt id="TITLE"><gi>title</gi>
<desc>contains the title of a work, whether article, book, journal, or
series, including any alternative titles or subtitles.</desc>
<attList>
<!-- .................................................. level -->
<attDef usage=rwa>
<attName>level
<name>bibliographic level (or class) of title
<desc>indicates whether this is the title of an article, book, journal,
series, or unpublished material.
<datatype>(a | m | j | s | u)
<valList type=closed>
    <val>a
    <desc>analytic title (article, poem, or other item published as
          part of a larger item)
    <val>m
    <desc>monographic title (book, collection, or other item published
          as a distinct item, including single volumes of multi-volume
          works)
    <val>j
    <desc>journal title
    <val>s
    <desc>series title
    <val>u
    <desc>title of unpublished material (including theses and
          dissertations unless published by a commercial press)
</valList>
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>If the title appears directly enclosed within an
<gi>analytic</gi> element, the <att>level</att>, if given, must be
<q>a</q>; if it appears directly enclosed within a <gi>monogr</gi>
element, <att>level</att> must be <q>m</q>, <q>j</q>, or <q>u</q>;
when <gi>title</gi> is directly enclosed by <gi>series</gi>,
<att>level</att> must be <q>s</q>.
</attDef>
<!-- ................................................... type -->
<attDef usage=opt>
<attName>type
<name>type of title
<desc>classifies the title according to some convenient typology.
<datatype>CDATA
<valList type=open>
    <val>main        <desc>main title
    <val>subordinate <desc>subtitle, title of part
    <val>parallel    <desc>alternate title, often in another language,
                           by which the work is also known
    <val>abbreviated <desc>abbreviated form of title
</valList>
<default>#IMPLIED
<eg><![ CDATA [
 
]]>
</eg>
<remarks><p>This attribute is provided for convenience in analysing
titles and processing them according to their type; where such
specialized processing is not necessary, there is no need for such
analysis, and the entire title, including subtitles and any parallel
titles, may be enclosed within a single <gi>title</gi> element.
</attDef>
</attList>
<exemplum><eg><![ CDATA[
<title>La vie mode d'emploi. Romans.</title>
]]>
</eg></exemplum>
<exemplum><eg><![ CDATA[
<title>Synthese: an international journal for epistemology, methodology
and history of science</title>
]]>
</eg></exemplum>
<exemplum><eg><![ CDATA[
<title>Information Technology and the Research Process: Proceedings
of a conference held at Cranfield Institute of Technology, UK, 18-21
July 1989</title>
]]>
</eg></exemplum>
<exemplum><eg><![ CDATA[
<title>Hardy's Tess of the D'Urbervilles: a machine readable edition
]]>
</eg></exemplum>
<remarks></remarks>
<part type=base name=core><classes names="HQPHRASE">
<dataDesc></dataDesc>
<elemDecl>- o (%paraContent)</elemDecl>
<xref target=COBICOR>
<xref target='HD21'>
<xref target='HD26'>
</tagDoc><!-- end of TITLE -->
<?tei:EOF title.tag ?>
