<?tei:SOF tree.tag ?>
<!-- ********** TREE                                          -->
<!-- $Id: tree.tag,v 1.4 93/09/22 19:22:23 msmcq Exp $ -->
<!-- $Log:	tree.tag,v $
# Revision 1.4  93/09/22  19:22:23  msmcq
# change for publication of GD
# 
# Revision 1.3  1993/09/15  22:56:03  msmcq
# Changes as of mid-September
# -->
<!-- Revisions:                                               -->
<!-- 93-09-17 : MSM : change model:  eliminate &              -->
<!--                  allow root to be in middle as well as   -->
<!--                  at begin or end of tree                 -->
<!-- 93-09-15 : MSM : trivial cleanup                         -->
<!-- 93-09-10 : MSM : Normalize GI case                       -->
<!-- 93-07-23 : DTL : modify P2 version:                      -->
<!--                  add label=                              -->
<!-- eliminate special drawing attributes (use rend=)         -->
<!-- change description of ord= so that it cannot be          -->
<!-- overriden in ROOT or InODE tags.  If ord=partial, then   -->
<!-- ord= values must be specified on ROOT and every InODE.   -->
<!-- follow= attribute can however impose a "local"           -->
<!-- ordering between two elements in a tree.                 -->
<!-- ********** TREE                                          -->
<tagDoc id=TREE usage=rwa>
<gi>tree</gi>
<desc>encodes a tree, which is made up of a root, internal nodes,
leaves, and arcs from root to leaves.
<attList>
<attDef id=TRLAB usage=opt>
<attName>label
<desc>gives a label for a tree.
<datatype>CDATA
<valDesc>A character string.
<default>#IMPLIED
</attDef>
<attDef id=TRARITY usage=opt>
<attName>arity
<desc>gives the maximum number of children of the root and internal
nodes of the tree.
<datatype>NUMBER
<valDesc>A nonnegative integer.
<default>#IMPLIED
</attDef>
<attDef id=TRORD usage=req>
<attName>ord
<desc>indicates whether or not the tree is ordered, or if it is
partially ordered.
<datatype>(Y | N | partial)
<valList type=closed>
<val>Y
<desc>indicates that all of the branching nodes of the tree are ordered.
<val>partial
<desc>indicates that some of the branching nodes of the tree are ordered
and some are unordered.
<val>N
<desc>indicates that all of the branching nodes of the tree are
unordered.
</valList>
<default>Y
</attDef>
<attDef id=TRORDER usage=opt>
<attName>order
<desc>gives the order of the tree, i.e., the number of its nodes.
<datatype>NUMBER
<valDesc>A nonnegative integer.
<default>#IMPLIED
<remarks><p>The size of a tree is always one less than its order, hence
there is no need for both a <att>size</att> and <att>order</att>
attribute.
</attDef>
</attList>
<exemplum>
<eg><![ CDATA [
<tree n='ex2' ord=partial arity=2 order=13>
   <root label='/' id=DIV1 ord=Y children='plu1 exp1'>
   <iNode label='+' id=PLU1 ord=N parent=div1 children='exp2 exp3'>
   <iNode label='**' id=EXP1 ord=Y parent=div1 children='plu2 num2.3'>
   <iNode label='**' id=EXP2 ord=Y parent=plu1 children='vara1 num2.1'>
   <iNode label='**' id=EXP3 ord=Y parent=plu1 children='varb1 num2.2'>
   <iNode label='+' id=PLU2 ord=N parent=exp1 children='vara2 varb2'>
   <leaf label='a' id=VARA1 parent=exp2>
   <leaf label='2' id=NUM2.1 parent=exp2>
   <leaf label='b' id=VARB1 parent=exp3>
   <leaf label='2' id=NUM2.2 parent=exp3>
   <leaf label='a' id=VARA2 parent=plu2>
   <leaf label='b' id=VARB2 parent=plu2>
   <leaf label='2' id=NUM2.3 parent=exp1>
   </tree>
]]>
</eg>
</exemplum>
<part type=top name=graphs><classes names=CHUNK>
<dataDesc>A root, and zero or more internal nodes and leaves, but if
there is an internal node, there must also be at least one leaf.
<elemDecl>- - ((leaf | iNode)*, root, (leaf | iNode)*)</elemDecl>
<xref type=div2 target=GDTR>
</tagDoc>
<?tei:EOF tree.tag ?>
