<?tei:SOF wsdlang.tag ?>
<!-- $Id: wsdlang.tag,v 1.3 94/03/21 14:33:13 lou Exp $ -->
<!-- $Log:	wsdlang.tag,v $
# Revision 1.3  94/03/21  14:33:13  lou
# second major typo purge
# 
# Revision 1.2  1994/01/04  12:15:45  lou
# fix xrefs
#
# Revision 1.1  1993/08/03  02:27:04  msmcq
# tagdoc files:  resynching uicvm and onions
# -->
<!-- *********************************************** language -->
<tagDoc id=WSDLANG usage=req>
<gi>language</gi>
<desc>identifies the language being described in the writing system
declaration.
<attList>
<!-- ................................................. iso639 -->
<attDef usage=req>
<attName>iso639
<desc>gives the standard language code from ISO 639.
<datatype>CDATA
<valDesc>any two- or three-letter code included included in ISO 639; if
the language is not included in the list in ISO 639, the value should be
given as the empty string.
<default>#REQUIRED
<remarks></remarks>
</attDef>
</attList>
<exemplum><eg><![ CDATA [
<language iso639=''>Various</language> 
<language iso639=GRC>Classical Greek</language>
]]>
</eg></exemplum>
<remarks><p>In general, the <soCalled>language</soCalled>
associated with a given writing system declaration will be a
natural language; it may however be a dialect, an artificial
language, or some other semiotic system conveniently treated as a
language.
 
<p>The content of the <gi>language</gi> element is a
description in prose of what language the WSD describes.
Usually this will simply be the conventional name of the
language; more information may however be included as needed.
 
<p>Specialized writing system declarations which document a public
character set or entity set suitable for encoding several languages, and
which are intended for use as a base component within other
language-specific writing system declarations, should identify the
<gi>language</gi> to which they apply as <q>Various</q>.  Such writing
systems should <emph>not</emph> be used directly by encoded texts; they
should be named only in the <gi>baseWsd</gi> element of
language-specific writing system declarations.
</remarks>
 
<part type=aux name=wsd>
<classes>
<dataDesc>May contain character data only.
<elemDecl>- O  (#PCDATA)
</elemDecl>
<xref target=WDLA>
<xref target=WDOV>
</tagDoc>
<?tei:EOF wsdlang.tag ?>
