<?tei:SOF wsdxfig.tag ?>
<!-- $Id: wsdxfig.tag,v 1.1 93/08/03 02:27:04 msmcq Exp $ -->
<!-- $Log:	wsdxfig.tag,v $
# Revision 1.1  93/08/03  02:27:04  msmcq
# tagdoc files:  resynching uicvm and onions
#  -->
<!-- ********************************************** extFigure -->
<tagDoc id=WSDXFIG usage=opt>
<gi>extFigure</gi>
<name>external figure
<desc>(in a writing system declaration) refers to a figure or
illustration depicting the character form, which is stored in
some declared notation external to the text.
<attList>
<!-- ............................................... notation -->
<attDef usage=req>
<attName>notation
<desc>identifies the notation in which the figure is stored.
<datatype>NAME
<valDesc>a valid SGML name associated with a given notation by means of
an SGML NOTATION declaration in the document type definition.
<default>#REQUIRED
<remarks><p></remarks>
</attDef>
<!-- ................................................. entity -->
<attDef usage=req>
<attName>entity
<desc>gives the SGML name of the external entity which contains the
figure.
<datatype>ENTITY
<valDesc>a valid SGML name associated with the external entity by means
of an SGML ENTITY declaration in the document type definition.
<default>#REQUIRED
<remarks><p></remarks>
</attDef>
</attList>
<exemplum><p>An image of the character form may be stored and
transmitted in any desired graphics format.  The declaration of the
notation may specify a local system identifier for the processor (here
it is imagined that we use a program called <q>pddraw.exe</q> to process
files in TIFF format), thus:</p>
<eg><![ CDATA [
 <!-- in the DTD: -->
 <!NOTATION TIFF system 'pddraw.exe'>
 <!ENTITY lcthorn system 'lcthorn.TIF' NDATA TIFF>
 
 <!-- in the WSD itself: -->
 <extFigure notation=TIFF entity='lcthorn'>
 
]]>
</eg></exemplum>
<exemplum><p>The graphics format might also be declared with a public
identifier in addition to the system identifier; this is likely to be
more comprehensible and thus more useful to users of a different
system:</p>
<eg><![ CDATA [
 <!-- in the DTD: -->
 <!NOTATION TIFF
            PUBLIC '-//XXX//NOTATION Tagged Image File Format//EN'
            'pddraw.exe'>
 <!ENTITY lcthorn system 'lcthorn.TIF' NDATA TIFF>
 
 <!-- in the WSD itself: -->
 <extFigure notation=TIFF entity='lcthorn'>
 
]]>
</eg></exemplum>
<exemplum><p>Character shapes may be conveniently conveyed in forms
other than graphics images; one might, for example, define a character
shape using a font-design program such as Donald Knuth's MetaFont
program (which can be used to generate fonts for processing with TeX):
</p>
<eg><![ CDATA [
 <!-- in the DTD: -->
 <!NOTATION metafont
            PUBLIC '-//DEK//NOTATION MetaFont//EN'
            'mf.exe'>
 <!ENTITY lcthorn system 'lcthorn.TIF' NDATA metafont>
 
 <!-- in the WSD itself: -->
 <extFigure notation=metafont entity='lcthorn'>
]]>
</eg></exemplum>
<remarks><p></remarks>
<part type=aux name=wsd>
<classes>
<dataDesc>Empty.
<elemDecl>- O  EMPTY
</elemDecl>
<xref target=WDCSEX>
</tagDoc>
<?tei:EOF wsdxfig.tag ?>
