/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.w3c.tools.jdbc.ConnectionManager;
import org.w3c.tools.jdbc.Jdbc;
import org.w3c.tools.jdbc.JdbcConnection;
import org.w3c.tools.jdbc.JdbcServerState;

public class JdbcServer {
    public static final boolean debug = false;
    String uri = null;
    String user = null;
    String password = null;
    ConnectionManager manager = null;
    JdbcServerState state = null;
    protected static HashMap servers = new HashMap();
    protected static Vector drivers = new Vector();
    protected static Properties defaultProps = new Properties();

    protected final JdbcServerState getState() {
        return this.state;
    }

    public static JdbcServer getServer(String string, String string2, String string3) {
        return JdbcServer.getServer(string, string2, string3, null, System.getProperties());
    }

    public static JdbcServer getServer(String string, Properties properties) {
        return JdbcServer.getServer(string, Jdbc.getUser(properties), Jdbc.getPassword(properties), Jdbc.getDriver(properties), properties);
    }

    public static JdbcServer getServer(String string, String string2, String string3, String string4) {
        return JdbcServer.getServer(string, string2, string3, string4, defaultProps);
    }

    public static JdbcServer getServer(String string, String string2, String string3, String string4, Properties properties) {
        if (drivers == null) {
            drivers = new Vector(4);
        }
        if (string4 != null && !drivers.contains(string4)) {
            try {
                Class.forName(string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            drivers.addElement(string4);
        }
        String string5 = null;
        string5 = string2 != null ? string + "?" + string2 : string;
        JdbcServer jdbcServer = null;
        jdbcServer = (JdbcServer)servers.get(string5);
        if (jdbcServer != null) {
            jdbcServer.updateProperties(properties);
            return jdbcServer;
        }
        ConnectionManager connectionManager = ConnectionManager.getManager(properties);
        jdbcServer = new JdbcServer(string, string2, string3, connectionManager);
        servers.put(string5, jdbcServer);
        return jdbcServer;
    }

    protected void updateProperties(Properties properties) {
        this.manager = ConnectionManager.getManager(properties);
    }

    public synchronized void unregisterConnection(JdbcConnection jdbcConnection) {
        this.manager.notifyUse(jdbcConnection);
    }

    public void deleteConnection(JdbcConnection jdbcConnection) {
        this.manager.deleteConnection(jdbcConnection);
    }

    public ResultSet runRequest(String string, boolean bl) throws SQLException {
        return this.runQuery(string, bl);
    }

    public ResultSet runQuery(String string, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        JdbcConnection jdbcConnection = null;
        int n = 3;
        boolean bl2 = bl;
        for (int i = 0; resultSet == null && i < n; ++i) {
            jdbcConnection = this.manager.getConnection(this);
            if (jdbcConnection == null) continue;
            try {
                resultSet = jdbcConnection.performQuery(string);
                continue;
            }
            catch (SQLException sQLException) {
                bl2 = true;
                throw sQLException;
            }
            finally {
                if (bl2) {
                    jdbcConnection.delete();
                } else {
                    this.manager.notifyIdle(jdbcConnection);
                }
            }
        }
        if (jdbcConnection == null) {
            throw new SQLException("Can't connect to database");
        }
        return resultSet;
    }

    public int runUpdate(String string, boolean bl) throws SQLException {
        int n = -1;
        JdbcConnection jdbcConnection = null;
        int n2 = 3;
        for (int i = 0; n == -1 && i < n2; ++i) {
            jdbcConnection = this.manager.getConnection(this);
            if (jdbcConnection == null) continue;
            try {
                n = jdbcConnection.performUpdate(string);
                continue;
            }
            catch (SQLException sQLException) {
                bl = true;
                throw sQLException;
            }
            finally {
                if (bl) {
                    jdbcConnection.delete();
                } else {
                    this.manager.notifyIdle(jdbcConnection);
                }
            }
        }
        if (jdbcConnection == null) {
            throw new SQLException("Can't connect to database");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = null;
        JdbcConnection jdbcConnection = null;
        int n = 3;
        for (int i = 0; databaseMetaData == null && i < n; ++i) {
            jdbcConnection = this.manager.getConnection(this);
            if (jdbcConnection == null) continue;
            try {
                databaseMetaData = jdbcConnection.getMetaData();
                continue;
            }
            finally {
                this.manager.notifyIdle(jdbcConnection);
            }
        }
        if (jdbcConnection == null) {
            throw new SQLException("Can't connect to database");
        }
        return databaseMetaData;
    }

    public String toString() {
        return this.uri;
    }

    protected JdbcServer(String string, String string2, String string3, ConnectionManager connectionManager) {
        this.uri = string;
        this.user = string2;
        this.password = string3;
        this.state = new JdbcServerState(this);
        this.manager = connectionManager;
    }
}

