/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Writer;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.FrameArrayAttribute;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.serialization.AttributeDescription;
import org.w3c.tools.resources.serialization.EmptyDescription;
import org.w3c.tools.resources.serialization.ResourceDescription;
import org.w3c.tools.resources.serialization.xml.JigXML;
import org.w3c.tools.resources.serialization.xml.XMLWriter;

public class XMLDescrWriter
extends XMLWriter
implements JigXML {
    protected void startResource(ResourceDescription resourceDescription) throws IOException {
        String string = resourceDescription.getClassName();
        this.writer.write(60);
        this.writer.write("resource");
        this.writer.write(32);
        this.writer.write("class");
        this.writer.write("='");
        this.writer.write(string);
        this.writer.write("'>\n");
        this.writeInherit(resourceDescription.getClassHierarchy(), 1);
        this.writeInterfaces(resourceDescription.getInterfaces());
    }

    protected void startDescription(ResourceDescription resourceDescription) throws IOException {
        String string = resourceDescription.getClassName();
        this.writer.write(60);
        this.writer.write("description");
        this.writer.write(" ");
        this.writer.write("class");
        this.writer.write("='");
        this.writer.write(string);
        String string2 = resourceDescription.getIdentifier();
        if (string2 == null) {
            string2 = "@@NULL@@";
        }
        this.writer.write("' ");
        this.writer.write("name");
        this.writer.write("='");
        this.writer.write(string2);
        this.writer.write("'>\n");
    }

    protected void closeDescription() throws IOException {
        this.writer.write("</");
        this.writer.write("description");
        this.writer.write(">\n");
    }

    protected void writeInherit(String[] stringArray, int n) throws IOException {
        if (n < stringArray.length) {
            ++this.level;
            this.indent();
            this.writer.write(60);
            this.writer.write("inherit");
            this.writer.write(32);
            this.writer.write("class");
            this.writer.write("='");
            this.writer.write(stringArray[n]);
            this.writer.write("'>\n");
            this.writeInherit(stringArray, ++n);
            this.indent();
            this.writer.write("</");
            this.writer.write("inherit");
            this.writer.write(">\n");
            --this.level;
        }
    }

    protected void writeInterfaces(String[] stringArray) throws IOException {
        ++this.level;
        for (int i = 0; i < stringArray.length; ++i) {
            this.indent();
            this.writer.write(60);
            this.writer.write("implements");
            this.writer.write(32);
            this.writer.write("class");
            this.writer.write("='");
            this.writer.write(stringArray[i]);
            this.writer.write("'/>\n");
        }
        --this.level;
    }

    protected void writeAttributeDescription(AttributeDescription attributeDescription) throws IOException {
        ++this.level;
        String string = attributeDescription.getClassName();
        Attribute attribute = attributeDescription.getAttribute();
        Object object = attributeDescription.getValue();
        if (attribute instanceof SimpleAttribute) {
            this.indent();
            this.writer.write("<attribute name='");
            this.writer.write(attributeDescription.getName());
            this.writer.write("' flag='");
            this.writer.write(attribute.getFlag());
            this.writer.write("' class='");
            this.writer.write(string);
            if (object == null) {
                this.writer.write("'>@@NULL@@");
            } else {
                this.writer.write("'>");
                this.writer.write(XMLDescrWriter.encode(((SimpleAttribute)attribute).pickle(object)));
            }
            this.writer.write("</");
            this.writer.write("attribute");
            this.writer.write(">\n");
        } else if (attribute instanceof ArrayAttribute) {
            this.indent();
            this.writer.write(60);
            this.writer.write("array");
            this.writer.write(32);
            this.writer.write("name");
            this.writer.write("='");
            this.writer.write(attributeDescription.getName());
            this.writer.write("' ");
            this.writer.write("flag");
            this.writer.write("='");
            this.writer.write(attribute.getFlag());
            this.writer.write("' ");
            this.writer.write("class");
            this.writer.write("='");
            this.writer.write(string);
            this.writer.write("' ");
            String[] stringArray = null;
            stringArray = object == null ? new String[]{} : ((ArrayAttribute)attribute).pickle(object);
            int n = stringArray.length;
            this.writer.write("length");
            this.writer.write("='");
            this.writer.write(String.valueOf(n));
            this.writer.write("'>\n");
            ++this.level;
            for (int i = 0; i < n; ++i) {
                this.indent();
                this.writer.write(60);
                this.writer.write("value");
                this.writer.write(62);
                this.writer.write(XMLDescrWriter.encode(stringArray[i]));
                this.writer.write("</");
                this.writer.write("value");
                this.writer.write(">\n");
            }
            --this.level;
            this.indent();
            this.writer.write("</");
            this.writer.write("array");
            this.writer.write(">\n");
        } else if (attribute instanceof FrameArrayAttribute) {
            this.indent();
            this.writer.write(60);
            this.writer.write("resourcearray");
            this.writer.write(32);
            this.writer.write("name");
            this.writer.write("='");
            this.writer.write(attributeDescription.getName());
            this.writer.write("' ");
            this.writer.write("class");
            this.writer.write("='");
            this.writer.write(string);
            this.writer.write("' ");
            ResourceDescription[] resourceDescriptionArray = null;
            resourceDescriptionArray = object == null ? new ResourceDescription[]{} : (ResourceDescription[])object;
            int n = resourceDescriptionArray.length;
            this.writer.write("length");
            this.writer.write("='");
            this.writer.write(String.valueOf(n));
            this.writer.write("'>\n");
            for (int i = 0; i < n; ++i) {
                this.writeResourceDescription(resourceDescriptionArray[i]);
            }
            this.indent();
            this.writer.write("</");
            this.writer.write("resourcearray");
            this.writer.write(">\n");
        }
        --this.level;
    }

    public void writeResourceDescription(ResourceDescription resourceDescription) throws IOException {
        ++this.level;
        this.indent();
        if (resourceDescription instanceof EmptyDescription) {
            this.startDescription(resourceDescription);
            this.indent();
            this.closeDescription();
        } else {
            this.startResource(resourceDescription);
            AttributeDescription[] attributeDescriptionArray = resourceDescription.getAttributeDescriptions();
            for (int i = 0; i < attributeDescriptionArray.length; ++i) {
                this.writeAttributeDescription(attributeDescriptionArray[i]);
            }
            this.indent();
            this.closeResource();
        }
        --this.level;
    }

    public XMLDescrWriter(Writer writer) {
        super(writer);
    }
}

