/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFChecker;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.WriterReportImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.ZipFile;

public class EpubCheck {
    public static final String VERSION = "1.1";
    File epubFile;
    Report userReport;
    public int warningCount;
    public int errorCount;

    static String fixMessage(String message) {
        return message.replaceAll("\r\n", " ").replaceAll("\r", " ").replaceAll("\n", " ");
    }

    public EpubCheck(File epubFile) {
        this.epubFile = epubFile;
        this.userReport = new DefaultReportImpl(epubFile.getName());
    }

    public EpubCheck(File epubFile, PrintWriter out) {
        this.epubFile = epubFile;
        this.userReport = new WriterReportImpl(out);
    }

    public EpubCheck(File epubFile, Report report) {
        this.epubFile = epubFile;
        this.userReport = report;
    }

    public boolean validate() {
        ProxyReport report = new ProxyReport();
        try {
            FileInputStream epubIn = new FileInputStream(this.epubFile);
            byte[] header = new byte[58];
            if (epubIn.read(header) != header.length) {
                report.error(null, 0, "cannot read header");
            } else {
                int fnsize = this.getIntFromBytes(header, 26);
                int extsize = this.getIntFromBytes(header, 28);
                if (header[0] != 80 && header[1] != 75) {
                    report.error(null, 0, "corrupted ZIP header");
                } else if (fnsize != 8) {
                    report.error(null, 0, "length of first filename in archive must be 8, but was " + fnsize);
                } else if (extsize != 0) {
                    report.error(null, 0, "extra field length for first filename must be 0, but was " + extsize);
                } else if (!CheckUtil.checkString(header, 30, "mimetype")) {
                    report.error(null, 0, "mimetype entry missing or not the first in archive");
                } else if (!CheckUtil.checkString(header, 38, "application/epub+zip")) {
                    report.error(null, 0, "mimetype contains wrong type (application/epub+zip expected)");
                }
            }
            epubIn.close();
            ZipFile zip = new ZipFile(this.epubFile);
            OCFPackage ocf = new OCFPackage(zip);
            OCFChecker checker = new OCFChecker(ocf, report);
            checker.runChecks();
            zip.close();
        }
        catch (IOException e) {
            report.error(null, 0, "I/O error: " + e.getMessage());
        }
        return this.warningCount == 0 && this.errorCount == 0;
    }

    private int getIntFromBytes(byte[] bytes, int offset) {
        int hi = 0xFF & bytes[offset + 1];
        int lo = 0xFF & bytes[offset + 0];
        return hi << 8 | lo;
    }

    class ProxyReport
    implements Report {
        ProxyReport() {
        }

        public void error(String resource, int line, String message) {
            ++EpubCheck.this.errorCount;
            EpubCheck.this.userReport.error(resource, line, EpubCheck.fixMessage(message));
        }

        public void warning(String resource, int line, String message) {
            ++EpubCheck.this.warningCount;
            EpubCheck.this.userReport.warning(resource, line, EpubCheck.fixMessage(message));
        }
    }
}

