/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.net.URL;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.www.http.HttpCookie;
import org.w3c.www.http.HttpCookieList;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpSetCookie;
import org.w3c.www.http.HttpSetCookieList;

public class CookieFilter
extends ResourceFilter {
    public static final String NAME = "org.w3c.jigsaw.filters.counter";
    protected static int ATTR_COOKIE_MAXAGE = -1;

    public int getCookieMaxAge() {
        return this.getInt(ATTR_COOKIE_MAXAGE, 20);
    }

    public ReplyInterface ingoingFilter(RequestInterface requestInterface) throws ProtocolException {
        return null;
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) throws ProtocolException {
        Object object;
        Request request = (Request)requestInterface;
        Reply reply = (Reply)replyInterface;
        int n = 1;
        HttpCookieList httpCookieList = request.getCookie();
        if (httpCookieList != null && (object = httpCookieList.getCookie(NAME)) != null) {
            System.out.println("cookie-count=" + ((HttpCookie)object).getValue());
            try {
                n = Integer.parseInt(((HttpCookie)object).getValue()) + 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = Integer.toString(n);
        FramedResource framedResource = this.getResource();
        if (framedResource instanceof HTTPFrame) {
            HTTPFrame hTTPFrame = (HTTPFrame)framedResource;
            HttpSetCookieList httpSetCookieList = HttpFactory.makeSetCookieList(null);
            HttpSetCookie httpSetCookie = httpSetCookieList.addSetCookie(NAME, (String)object);
            httpSetCookie.setMaxAge(this.getCookieMaxAge());
            URL uRL = hTTPFrame.getURL(request);
            httpSetCookie.setPath(uRL.getFile());
            httpSetCookie.setDomain(uRL.getHost());
            reply.setSetCookie(httpSetCookieList);
            reply.addNoCache("Set-Cookie");
        }
        return null;
    }

    static {
        Class<?> clazz = null;
        IntegerAttribute integerAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.CookieFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("cookie-maxage", new Integer(20), 2);
        ATTR_COOKIE_MAXAGE = AttributeRegistry.registerAttribute(clazz, integerAttribute);
    }
}

