/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.indexer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.indexer.SampleResourceIndexer;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.MimeParserMessageFactory;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeType;

public class ConfigResourceIndexer
extends SampleResourceIndexer {
    private File getConfigFile(File file, String string) {
        File file2;
        File file3 = new File(file, ".meta");
        if (file3.exists() && file3.isDirectory() && (file2 = new File(file3, string + ".meta")).exists() && !file2.isDirectory()) {
            return file2;
        }
        return null;
    }

    public Resource createResource(ContainerResource containerResource, RequestInterface requestInterface, File file, String string, Hashtable hashtable) {
        Resource resource = super.createResource(containerResource, requestInterface, file, string, hashtable);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.frames.HTTPFrame");
        }
        catch (Exception exception) {
            return resource;
        }
        if (resource == null) {
            return resource;
        }
        HTTPFrame hTTPFrame = null;
        ResourceFrame[] resourceFrameArray = resource.collectFrames(clazz);
        if (resourceFrameArray != null) {
            hTTPFrame = (HTTPFrame)resourceFrameArray[0];
        }
        if (hTTPFrame == null) {
            return resource;
        }
        File file2 = this.getConfigFile(file, string);
        if (file2 != null) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                MimeParser mimeParser = new MimeParser(bufferedInputStream, new MimeParserMessageFactory());
                HttpEntityMessage httpEntityMessage = (HttpEntityMessage)mimeParser.parse();
                Enumeration enumeration = httpEntityMessage.enumerateHeaderDescriptions();
                while (enumeration.hasMoreElements()) {
                    String[] stringArray;
                    HeaderDescription headerDescription = (HeaderDescription)enumeration.nextElement();
                    if (headerDescription.isHeader(HttpEntityMessage.H_CONTENT_TYPE)) {
                        stringArray = null;
                        try {
                            stringArray = httpEntityMessage.getContentType();
                        }
                        catch (Exception exception) {
                            stringArray = MimeType.APPLICATION_OCTET_STREAM;
                        }
                        if (stringArray.hasParameter("charset")) {
                            String string2 = stringArray.getParameterValue("charset");
                            MimeType mimeType = new MimeType(stringArray.getType(), stringArray.getSubtype());
                            hTTPFrame.setValue("content-type", (Object)mimeType);
                            hTTPFrame.setValue("charset", (Object)string2);
                            continue;
                        }
                        hTTPFrame.setValue("content-type", (Object)stringArray);
                        continue;
                    }
                    if (headerDescription.isHeader(HttpEntityMessage.H_CONTENT_LANGUAGE)) {
                        stringArray = httpEntityMessage.getContentLanguage();
                        if (stringArray.length <= 0) continue;
                        hTTPFrame.setValue("content-language", (Object)stringArray[0]);
                        continue;
                    }
                    if (!headerDescription.isHeader(HttpEntityMessage.H_CONTENT_ENCODING) || (stringArray = httpEntityMessage.getContentEncoding()).length <= 0) continue;
                    hTTPFrame.setValue("content-encoding", (Object)stringArray[0]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return resource;
    }
}

