/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.ssi;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

class SegmentInputStream
extends InputStream {
    private RandomAccessFile file;
    private long bytesLeft;

    SegmentInputStream(RandomAccessFile randomAccessFile, long l, long l2) throws IOException {
        this.file = randomAccessFile;
        randomAccessFile.seek(l);
        this.bytesLeft = l2;
    }

    public final void close() throws IOException {
    }

    public final int read() throws IOException {
        if (this.bytesLeft > 0L) {
            --this.bytesLeft;
            return this.file.read();
        }
        return -1;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytesLeft == 0L) {
            return -1;
        }
        if ((long)n2 > this.bytesLeft) {
            n2 = (int)this.bytesLeft;
        }
        this.file.readFully(byArray, n, n2);
        this.bytesLeft -= (long)n2;
        return n2;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final void reset() throws IOException {
        throw new IOException("mark not supported");
    }

    public final void mark(int n) {
    }

    public final boolean markSupported() {
        return false;
    }

    public final long skip(long l) throws IOException {
        if (l > this.bytesLeft) {
            l = this.bytesLeft;
        }
        return this.file.skipBytes((int)l);
    }

    public final int available() {
        return (int)this.bytesLeft;
    }
}

