/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.util.EventObject;
import java.util.Hashtable;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ResourceSpace;
import org.w3c.tools.resources.event.AttributeChangedEvent;
import org.w3c.tools.resources.event.AttributeChangedListener;
import org.w3c.tools.resources.event.FrameEvent;
import org.w3c.tools.resources.event.FrameEventListener;
import org.w3c.tools.resources.event.ResourceEvent;
import org.w3c.tools.resources.event.ResourceEventMulticaster;
import org.w3c.tools.resources.event.StructureChangedEvent;
import org.w3c.tools.resources.event.StructureChangedListener;

public class FramedResource
extends Resource
implements FrameEventListener {
    protected final boolean debugEvent = false;
    protected boolean event_disabled = false;
    protected Hashtable framesRef = null;
    protected AttributeChangedListener attrListener = null;
    protected StructureChangedListener structListener = null;
    protected static int ATTR_OID = -1;

    protected void disableEvent() {
        this.event_disabled = true;
    }

    protected void enableEvent() {
        this.event_disabled = false;
    }

    protected boolean eventDisabled() {
        return this.event_disabled;
    }

    public Object getClone(Object[] objectArray) {
        FramedResource framedResource = (FramedResource)super.getClone(objectArray);
        framedResource.framesRef = new Hashtable(3);
        return framedResource;
    }

    public int getOid() {
        int n = this.getInt(ATTR_OID, -1);
        if (n == -1) {
            double d = Math.random() * 2.147483647E9;
            n = (int)d;
            this.setInt(ATTR_OID, n);
        }
        return n;
    }

    protected void displayEvent(FramedResource framedResource, EventObject eventObject) {
        System.out.println(">>> [" + framedResource.getIdentifier() + "] has receive " + eventObject);
    }

    public void frameAdded(FrameEvent frameEvent) {
        if (!this.isUnloaded()) {
            this.markModified();
        }
    }

    public void frameModified(FrameEvent frameEvent) {
        if (!this.isUnloaded()) {
            this.markModified();
        }
    }

    public void frameRemoved(FrameEvent frameEvent) {
        if (!this.isUnloaded()) {
            this.markModified();
        }
    }

    public void registerFrame(ResourceFrame resourceFrame, Hashtable hashtable) {
        super.registerFrame(resourceFrame, hashtable);
        resourceFrame.addFrameEventListener(this);
        this.addAttributeChangedListener(resourceFrame);
        resourceFrame.registerResource(this);
    }

    protected void registerFrameIfNone(String string, String string2) throws ClassNotFoundException, IllegalAccessException, InstantiationException, ClassCastException {
        Class<?> clazz = Class.forName(string);
        ResourceFrame resourceFrame = this.getFrame(clazz);
        if (resourceFrame == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
            hashtable.put(id, string2);
            this.registerFrame((ResourceFrame)clazz.newInstance(), hashtable);
        }
    }

    public synchronized void unregisterFrame(ResourceFrame resourceFrame) {
        super.unregisterFrame(resourceFrame);
        resourceFrame.unregisterResource(this);
        resourceFrame.removeFrameEventListener(this);
        this.removeAttributeChangedListener(resourceFrame);
    }

    private ResourceReference[] getReferenceArray(ResourceFrame[] resourceFrameArray) {
        if (resourceFrameArray == null) {
            return null;
        }
        ResourceReference[] resourceReferenceArray = new ResourceReference[resourceFrameArray.length];
        ResourceReference resourceReference = null;
        for (int i = 0; i < resourceFrameArray.length; ++i) {
            resourceReference = (ResourceReference)this.framesRef.get(resourceFrameArray[i]);
            if (resourceReference == null) {
                resourceReference = new FrameReference(resourceFrameArray[i], this.getResourceReference());
                this.framesRef.put(resourceFrameArray[i], resourceReference);
            }
            resourceReferenceArray[i] = resourceReference;
        }
        return resourceReferenceArray;
    }

    public synchronized ResourceReference[] getFramesReference() {
        return this.getReferenceArray(this.getFrames());
    }

    public synchronized ResourceReference[] collectFramesReference(Class clazz) {
        return this.getReferenceArray(this.collectFrames(clazz));
    }

    public synchronized ResourceReference getFrameReference(Class clazz) {
        ResourceFrame resourceFrame = this.getFrame(clazz);
        if (resourceFrame == null) {
            return null;
        }
        ResourceReference resourceReference = (ResourceReference)this.framesRef.get(resourceFrame);
        if (resourceReference == null) {
            resourceReference = new FrameReference(resourceFrame, this.getResourceReference());
            this.framesRef.put(resourceFrame, resourceReference);
        }
        return resourceReference;
    }

    public synchronized ResourceReference getFrameReference(ResourceFrame resourceFrame) {
        ResourceReference resourceReference = (ResourceReference)this.framesRef.get(resourceFrame);
        if (resourceReference == null) {
            resourceReference = new FrameReference(resourceFrame, this.getResourceReference());
            this.framesRef.put(resourceFrame, resourceReference);
        }
        return resourceReference;
    }

    public synchronized ResourceFrame getFrame(Class clazz, String string) {
        ResourceFrame[] resourceFrameArray = this.collectFrames(clazz);
        if (resourceFrameArray != null) {
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                ResourceFrame resourceFrame = resourceFrameArray[i];
                if (!resourceFrame.getIdentifier().equals(string)) continue;
                return resourceFrame;
            }
        }
        return null;
    }

    ResourceFrame unsafeGetFrame(Class clazz, String string) {
        ResourceFrame[] resourceFrameArray = this.collectFrames(clazz);
        if (resourceFrameArray != null) {
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                ResourceFrame resourceFrame = resourceFrameArray[i];
                if (!resourceFrame.getIdentifier().equals(string)) continue;
                return resourceFrame;
            }
        }
        return null;
    }

    public synchronized ResourceFrame getFrame(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return this.getFrame(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void processEvent(ResourceEvent resourceEvent) {
        if (resourceEvent instanceof StructureChangedEvent) {
            this.fireStructureChangedEvent((StructureChangedEvent)resourceEvent);
        } else if (resourceEvent instanceof AttributeChangedEvent) {
            this.fireAttributeChangeEvent((AttributeChangedEvent)resourceEvent);
        }
    }

    public void postEvent(ResourceEvent resourceEvent) {
        if (this.eventDisabled()) {
            return;
        }
        ResourceSpace resourceSpace = this.getSpace();
        if (resourceSpace != null) {
            resourceSpace.getEventQueue().sendEvent(resourceEvent);
        }
    }

    public void addAttributeChangedListener(AttributeChangedListener attributeChangedListener) {
        this.attrListener = ResourceEventMulticaster.add(this.attrListener, attributeChangedListener);
    }

    public void removeAttributeChangedListener(AttributeChangedListener attributeChangedListener) {
        this.attrListener = ResourceEventMulticaster.remove(this.attrListener, attributeChangedListener);
    }

    protected void postAttributeChangeEvent(int n, Object object) {
        if (this.eventDisabled()) {
            return;
        }
        if (this.attrListener != null && this.getResourceReference() != null) {
            AttributeChangedEvent attributeChangedEvent = new AttributeChangedEvent(this.getResourceReference(), this.attributes[n], object);
            this.fireAttributeChangeEvent(attributeChangedEvent);
        }
    }

    protected void fireAttributeChangeEvent(AttributeChangedEvent attributeChangedEvent) {
        if (this.attrListener != null) {
            this.attrListener.attributeChanged(attributeChangedEvent);
        }
    }

    public void addStructureChangedListener(StructureChangedListener structureChangedListener) {
        this.structListener = ResourceEventMulticaster.add(this.structListener, structureChangedListener);
    }

    public void removeStructureChangedListener(StructureChangedListener structureChangedListener) {
        this.structListener = ResourceEventMulticaster.remove(this.structListener, structureChangedListener);
    }

    protected void postStructureChangedEvent(ResourceReference resourceReference, int n) {
        if (this.structListener != null && resourceReference != null) {
            StructureChangedEvent structureChangedEvent = new StructureChangedEvent(resourceReference, n);
            this.postEvent(structureChangedEvent);
        }
    }

    protected void postStructureChangedEvent(int n) {
        if (this.structListener != null && this.getResourceReference() != null) {
            StructureChangedEvent structureChangedEvent = new StructureChangedEvent(this.getResourceReference(), n);
            this.postEvent(structureChangedEvent);
        }
    }

    protected void fireStructureChangedEvent(int n) {
        ResourceReference resourceReference;
        if (this.structListener != null && (resourceReference = this.unsafeGetResourceReference()) != null) {
            StructureChangedEvent structureChangedEvent = new StructureChangedEvent(resourceReference, n);
            this.fireStructureChangedEvent(structureChangedEvent);
        }
    }

    protected void fireStructureChangedEvent(StructureChangedEvent structureChangedEvent) {
        if (this.structListener != null) {
            int n = structureChangedEvent.getID();
            switch (n) {
                case 1001: {
                    this.structListener.resourceModified(structureChangedEvent);
                    break;
                }
                case 1002: {
                    this.structListener.resourceCreated(structureChangedEvent);
                    break;
                }
                case 1003: {
                    this.structListener.resourceRemoved(structureChangedEvent);
                    break;
                }
                case 1004: {
                    this.structListener.resourceUnloaded(structureChangedEvent);
                }
            }
        }
    }

    public void notifyUnload() {
        ResourceFrame[] resourceFrameArray = this.unsafeGetFrames();
        if (resourceFrameArray != null) {
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                if (resourceFrameArray[i] == null) continue;
                resourceFrameArray[i].notifyUnload();
            }
        }
        this.fireStructureChangedEvent(1004);
        super.notifyUnload();
    }

    public synchronized void delete() throws MultipleLockException {
        this.disableEvent();
        this.fireStructureChangedEvent(1003);
        ResourceFrame[] resourceFrameArray = this.getFrames();
        if (resourceFrameArray != null) {
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                if (resourceFrameArray[i] == null) continue;
                resourceFrameArray[i].removeFrameEventListener(this);
                this.removeAttributeChangedListener(resourceFrameArray[i]);
                resourceFrameArray[i].unregisterResource(this);
            }
        }
        try {
            super.delete();
        }
        catch (MultipleLockException multipleLockException) {
            this.enableEvent();
            throw multipleLockException;
        }
    }

    public void markModified() {
        super.markModified();
        this.postStructureChangedEvent(1001);
    }

    public synchronized void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n != ATTR_LAST_MODIFIED) {
            this.postAttributeChangeEvent(n, object);
            this.postStructureChangedEvent(1001);
        }
    }

    public synchronized void setSilentValue(int n, Object object) {
        this.disableEvent();
        super.setValue(n, object);
        this.enableEvent();
    }

    public synchronized void setSilentValue(String string, Object object) {
        this.disableEvent();
        super.setValue(string, object);
        this.enableEvent();
    }

    public boolean lookup(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        ResourceFrame[] resourceFrameArray = this.getFrames();
        if (resourceFrameArray != null) {
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                if (resourceFrameArray[i] == null || !resourceFrameArray[i].lookup(lookupState, lookupResult)) continue;
                return true;
            }
        }
        if (lookupState.hasMoreComponents()) {
            lookupResult.setTarget(null);
            return false;
        }
        lookupResult.setTarget(this.getResourceReference());
        return true;
    }

    protected ReplyInterface performFrames(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        ResourceFrame[] resourceFrameArray = this.getFrames();
        if (resourceFrameArray != null) {
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                ReplyInterface replyInterface;
                if (resourceFrameArray[i] == null || (replyInterface = resourceFrameArray[i].perform(requestInterface)) == null) continue;
                return replyInterface;
            }
        }
        return null;
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        return this.performFrames(requestInterface);
    }

    public void initialize(Object[] objectArray) {
        this.attrListener = null;
        this.structListener = null;
        this.disableEvent();
        super.initialize(objectArray);
        ResourceFrame[] resourceFrameArray = this.getFrames();
        if (resourceFrameArray != null) {
            this.framesRef = new Hashtable(Math.max(resourceFrameArray.length, 1));
            Hashtable hashtable = new Hashtable(3);
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                if (resourceFrameArray[i] == null) continue;
                resourceFrameArray[i].registerResource(this);
                resourceFrameArray[i].initialize(hashtable);
                resourceFrameArray[i].addFrameEventListener(this);
                this.addAttributeChangedListener(resourceFrameArray[i]);
            }
        } else {
            this.framesRef = new Hashtable(3);
        }
        this.enableEvent();
    }

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.FramedResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("oid", null, 1);
        ATTR_OID = AttributeRegistry.registerAttribute(clazz, integerAttribute);
    }

    class FrameReference
    implements ResourceReference {
        Class frameClass = null;
        String identifier = null;
        ResourceReference framedr = null;
        int lockCount = 0;

        public void updateContext(ResourceContext resourceContext) {
        }

        public int nbLock() {
            return this.lockCount;
        }

        public Resource lock() throws InvalidResourceException {
            FramedResource framedResource = (FramedResource)this.framedr.lock();
            ++this.lockCount;
            return framedResource.getFrame(this.frameClass, this.identifier);
        }

        public Resource unsafeLock() throws InvalidResourceException {
            FramedResource framedResource = (FramedResource)this.framedr.lock();
            ++this.lockCount;
            return framedResource.unsafeGetFrame(this.frameClass, this.identifier);
        }

        public void unlock() {
            this.framedr.unlock();
            --this.lockCount;
        }

        public boolean isLocked() {
            return this.lockCount != 0;
        }

        FrameReference(ResourceFrame resourceFrame, ResourceReference resourceReference) {
            this.frameClass = resourceFrame.getClass();
            this.framedr = resourceReference;
            this.identifier = resourceFrame.getIdentifier();
        }
    }
}

